/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.RangeSet;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.collections.spatial.search.Bound;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.segment.filter.SpatialFilter;

public class SpatialDimFilter
extends AbstractOptimizableDimFilter
implements DimFilter {
    private final String dimension;
    private final Bound bound;
    @Nullable
    private final FilterTuning filterTuning;

    @JsonCreator
    public SpatialDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="bound") Bound bound, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        Preconditions.checkArgument((bound != null ? 1 : 0) != 0, (Object)"bound must not be null");
        this.dimension = dimension;
        this.bound = bound;
        this.filterTuning = filterTuning;
    }

    @VisibleForTesting
    public SpatialDimFilter(String dimension, Bound bound) {
        this(dimension, bound, null);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimBytes = StringUtils.toUtf8(this.dimension);
        byte[] boundBytes = this.bound.getCacheKey();
        return ByteBuffer.allocate(2 + dimBytes.length + boundBytes.length).put((byte)8).put(dimBytes).put((byte)-1).put(boundBytes).array();
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public Bound getBound() {
        return this.bound;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    @Override
    public Filter toFilter() {
        return new SpatialFilter(this.dimension, this.bound, this.filterTuning);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    public String toString() {
        return "SpatialDimFilter{dimension='" + this.dimension + "', bound=" + this.bound + ", filterTuning=" + this.filterTuning + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpatialDimFilter that = (SpatialDimFilter)o;
        return this.dimension.equals(that.dimension) && this.bound.equals(that.bound) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.bound, this.filterTuning);
    }
}

