/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.FrameSignaturePair;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryLimitRowIterator;
import org.apache.druid.query.scan.ScanQueryOffsetSequence;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.scan.ScanResultValueFramesIterable;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.utils.CloseableUtils;

public class ScanQueryQueryToolChest
extends QueryToolChest<ScanResultValue, ScanQuery> {
    private static final byte SCAN_QUERY = 19;
    private static final byte CACHE_STRATEGY_VERSION = 1;
    private static final TypeReference<ScanResultValue> TYPE_REFERENCE = new TypeReference<ScanResultValue>(){};
    private final GenericQueryMetricsFactory queryMetricsFactory;

    @Inject
    public ScanQueryQueryToolChest(GenericQueryMetricsFactory queryMetricsFactory) {
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<ScanResultValue> mergeResults(final QueryRunner<ScanResultValue> runner) {
        return (queryPlus, responseContext) -> {
            long newLimit;
            ScanQuery originalQuery = (ScanQuery)queryPlus.getQuery();
            ScanQuery.verifyOrderByForNativeExecution(originalQuery);
            if (!originalQuery.isLimited()) {
                newLimit = Long.MAX_VALUE;
            } else {
                if (originalQuery.getScanRowsLimit() > Long.MAX_VALUE - originalQuery.getScanRowsOffset()) {
                    throw new ISE("Cannot apply limit[%d] with offset[%d] due to overflow", originalQuery.getScanRowsLimit(), originalQuery.getScanRowsOffset());
                }
                newLimit = originalQuery.getScanRowsLimit() + originalQuery.getScanRowsOffset();
            }
            final ScanQuery queryToRun = originalQuery.withOffset(0L).withLimit(newLimit);
            Sequence<ScanResultValue> results = !queryToRun.isLimited() ? runner.run(queryPlus.withQuery(queryToRun), responseContext) : new BaseSequence<ScanResultValue, ScanQueryLimitRowIterator>(new BaseSequence.IteratorMaker<ScanResultValue, ScanQueryLimitRowIterator>(){

                @Override
                public ScanQueryLimitRowIterator make() {
                    return new ScanQueryLimitRowIterator(runner, queryPlus.withQuery(queryToRun), responseContext);
                }

                @Override
                public void cleanup(ScanQueryLimitRowIterator iterFromMake) {
                    CloseableUtils.closeAndWrapExceptions(iterFromMake);
                }
            });
            if (originalQuery.getScanRowsOffset() > 0L) {
                return new ScanQueryOffsetSequence(results, originalQuery.getScanRowsOffset());
            }
            return results;
        };
    }

    @Override
    public QueryMetrics<Query<?>> makeMetrics(ScanQuery query) {
        return this.queryMetricsFactory.makeMetrics(query);
    }

    @Override
    public Function<ScanResultValue, ScanResultValue> makePreComputeManipulatorFn(ScanQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<ScanResultValue> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public QueryRunner<ScanResultValue> preMergeQueryDecoration(QueryRunner<ScanResultValue> runner) {
        return (queryPlus, responseContext) -> runner.run(queryPlus, responseContext);
    }

    @Override
    public RowSignature resultArraySignature(ScanQuery query) {
        return query.getRowSignature();
    }

    @Override
    public Optional<Sequence<FrameSignaturePair>> resultsAsFrames(ScanQuery query, Sequence<ScanResultValue> resultSequence, MemoryAllocatorFactory memoryAllocatorFactory, boolean useNestedForUnknownTypes) {
        RowSignature defaultRowSignature = this.resultArraySignature(query);
        return Optional.of(Sequences.simple(new ScanResultValueFramesIterable(resultSequence, memoryAllocatorFactory, useNestedForUnknownTypes, defaultRowSignature, rowSignature -> ScanQueryQueryToolChest.getResultFormatMapper(query.getResultFormat(), rowSignature.getColumnNames()))));
    }

    @Override
    public Sequence<Object[]> resultsAsArrays(ScanQuery query, Sequence<ScanResultValue> resultSequence) {
        Function<?, Object[]> mapper = ScanQueryQueryToolChest.getResultFormatMapper(query.getResultFormat(), this.resultArraySignature(query).getColumnNames());
        return resultSequence.flatMap(result -> {
            List rows = (List)result.getEvents();
            Iterable arrays = Iterables.transform((Iterable)rows, (Function)mapper);
            return Sequences.simple(arrays);
        });
    }

    @Override
    public CacheStrategy<ScanResultValue, ScanResultValue, ScanQuery> getCacheStrategy(ScanQuery query, @Nullable ObjectMapper objectMapper) {
        return new CacheStrategy<ScanResultValue, ScanResultValue, ScanQuery>(){

            @Override
            public boolean isCacheable(ScanQuery query, boolean willMergeRunners, boolean segmentLevel) {
                return !query.context().isBySegment() && (!segmentLevel || willMergeRunners);
            }

            @Override
            public byte[] computeCacheKey(ScanQuery query) {
                List<ColumnType> columnTypes;
                CacheKeyBuilder builder = new CacheKeyBuilder(19).appendByte((byte)1).appendCacheable(query.getVirtualColumns()).appendString(query.getResultFormat().toString()).appendLong(query.getScanRowsOffset()).appendLong(query.getScanRowsLimit()).appendCacheable(query.getFilter()).appendStrings(query.getColumns() != null ? query.getColumns() : List.of()).appendCacheable(query.getTimeOrder());
                List<OrderBy> orderBys = query.getOrderBys();
                if (orderBys != null) {
                    builder.appendCacheables(orderBys);
                }
                if ((columnTypes = query.getColumnTypes()) != null) {
                    builder.appendCacheables(columnTypes);
                }
                return builder.build();
            }

            @Override
            public byte[] computeResultLevelCacheKey(ScanQuery query) {
                return this.computeCacheKey(query);
            }

            @Override
            public TypeReference<ScanResultValue> getCacheObjectClazz() {
                return TYPE_REFERENCE;
            }

            @Override
            public Function<ScanResultValue, ScanResultValue> prepareForCache(boolean isResultLevelCache) {
                return input -> input;
            }

            @Override
            public Function<ScanResultValue, ScanResultValue> pullFromCache(boolean isResultLevelCache) {
                return input -> input;
            }
        };
    }

    private static Function<?, Object[]> getResultFormatMapper(ScanQuery.ResultFormat resultFormat, List<String> fields) {
        Function mapper;
        switch (resultFormat) {
            case RESULT_FORMAT_LIST: {
                mapper = row -> {
                    Object[] rowArray = new Object[fields.size()];
                    for (int i = 0; i < fields.size(); ++i) {
                        rowArray[i] = row.get(fields.get(i));
                    }
                    return rowArray;
                };
                break;
            }
            case RESULT_FORMAT_COMPACTED_LIST: {
                mapper = row -> {
                    if (row.size() == fields.size()) {
                        return row.toArray();
                    }
                    if (fields.isEmpty()) {
                        return new Object[0];
                    }
                    throw new ISE("Mismatch in expected[%d] vs actual[%s] field count", fields.size(), row.size());
                };
                break;
            }
            default: {
                throw new UOE("Unsupported resultFormat for array-based results: %s", new Object[]{resultFormat});
            }
        }
        return mapper;
    }
}

