/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SubclassesMustOverrideEqualsAndHashCode;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.groupby.DeferExpressionDimensions;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.SelectableColumn;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.serde.NoIndexesColumnIndexSupplier;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.virtual.FallbackVirtualColumn;
import org.apache.druid.segment.virtual.FeaturelessSelectableColumn;
import org.apache.druid.segment.virtual.ListFilteredVirtualColumn;
import org.apache.druid.segment.virtual.PrefixFilteredVirtualColumn;
import org.apache.druid.segment.virtual.RegexFilteredVirtualColumn;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="expression", value=ExpressionVirtualColumn.class), @JsonSubTypes.Type(name="fallback", value=FallbackVirtualColumn.class), @JsonSubTypes.Type(name="mv-filtered", value=ListFilteredVirtualColumn.class), @JsonSubTypes.Type(name="mv-regex-filtered", value=RegexFilteredVirtualColumn.class), @JsonSubTypes.Type(name="mv-prefix-filtered", value=PrefixFilteredVirtualColumn.class)})
public interface VirtualColumn
extends Cacheable {
    public String getOutputName();

    default public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory columnSelectorFactory, @Nullable ColumnSelector columnSelector, @Nullable ReadableOffset offset) {
        DimensionSelector selector;
        if (columnSelector != null && (selector = this.makeDimensionSelector(dimensionSpec, columnSelector, offset)) != null) {
            return selector;
        }
        return this.makeDimensionSelector(dimensionSpec, columnSelectorFactory);
    }

    @Deprecated
    default public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        throw DruidException.forPersona(DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.UNSUPPORTED).build("Implement makeDimensionSelector(DimensionSpec, ColumnSelector, ColumnSelectorFactory, ReadableOffset) for[%s]", this.getClass());
    }

    @Deprecated
    @Nullable
    default public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelector columnSelector, ReadableOffset offset) {
        return null;
    }

    default public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory columnSelectorFactory, @Nullable ColumnSelector columnSelector, @Nullable ReadableOffset offset) {
        ColumnValueSelector<?> selector;
        if (columnSelector != null && offset != null && (selector = this.makeColumnValueSelector(columnName, columnSelector, offset)) != null) {
            return selector;
        }
        return this.makeColumnValueSelector(columnName, columnSelectorFactory);
    }

    @Deprecated
    default public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        throw DruidException.forPersona(DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.UNSUPPORTED).build("Implement makeColumnValueSelector(String, ColumnSelectorFactory, ColumnSelector, ReadableOffset) for[%s]", this.getClass());
    }

    @Deprecated
    @Nullable
    default public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelector columnSelector, ReadableOffset offset) {
        return null;
    }

    default public boolean canVectorize(ColumnInspector inspector) {
        return false;
    }

    default public SingleValueDimensionVectorSelector makeSingleValueVectorDimensionSelector(DimensionSpec dimensionSpec, VectorColumnSelectorFactory factory, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        SingleValueDimensionVectorSelector selector = this.makeSingleValueVectorDimensionSelector(dimensionSpec, columnSelector, offset);
        if (selector != null) {
            return selector;
        }
        return this.makeSingleValueVectorDimensionSelector(dimensionSpec, factory);
    }

    @Deprecated
    default public SingleValueDimensionVectorSelector makeSingleValueVectorDimensionSelector(DimensionSpec dimensionSpec, VectorColumnSelectorFactory factory) {
        throw new UnsupportedOperationException("not supported");
    }

    @Deprecated
    @Nullable
    default public SingleValueDimensionVectorSelector makeSingleValueVectorDimensionSelector(DimensionSpec dimensionSpec, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        return null;
    }

    default public MultiValueDimensionVectorSelector makeMultiValueVectorDimensionSelector(DimensionSpec dimensionSpec, VectorColumnSelectorFactory factory, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        MultiValueDimensionVectorSelector selector = this.makeMultiValueVectorDimensionSelector(dimensionSpec, columnSelector, offset);
        if (selector != null) {
            return selector;
        }
        return this.makeMultiValueVectorDimensionSelector(dimensionSpec, factory);
    }

    @Deprecated
    default public MultiValueDimensionVectorSelector makeMultiValueVectorDimensionSelector(DimensionSpec dimensionSpec, VectorColumnSelectorFactory factory) {
        throw new UnsupportedOperationException("not supported");
    }

    @Nullable
    @Deprecated
    default public MultiValueDimensionVectorSelector makeMultiValueVectorDimensionSelector(DimensionSpec dimensionSpec, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        return null;
    }

    default public VectorValueSelector makeVectorValueSelector(String columnName, VectorColumnSelectorFactory factory, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        VectorValueSelector selector = this.makeVectorValueSelector(columnName, columnSelector, offset);
        if (selector != null) {
            return selector;
        }
        return this.makeVectorValueSelector(columnName, factory);
    }

    @Deprecated
    default public VectorValueSelector makeVectorValueSelector(String columnName, VectorColumnSelectorFactory factory) {
        throw new UnsupportedOperationException("not supported");
    }

    @Nullable
    @Deprecated
    default public VectorValueSelector makeVectorValueSelector(String columnName, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        return null;
    }

    default public VectorObjectSelector makeVectorObjectSelector(String columnName, VectorColumnSelectorFactory factory, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        VectorObjectSelector selector = this.makeVectorObjectSelector(columnName, columnSelector, offset);
        if (selector != null) {
            return selector;
        }
        return this.makeVectorObjectSelector(columnName, factory);
    }

    @Deprecated
    default public VectorObjectSelector makeVectorObjectSelector(String columnName, VectorColumnSelectorFactory factory) {
        throw new UnsupportedOperationException("not supported");
    }

    @Nullable
    @Deprecated
    default public VectorObjectSelector makeVectorObjectSelector(String columnName, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        return null;
    }

    @Nullable
    default public GroupByVectorColumnSelector makeGroupByVectorColumnSelector(String columnName, VectorColumnSelectorFactory factory, DeferExpressionDimensions deferExpressionDimensions) {
        return null;
    }

    @Deprecated
    public ColumnCapabilities capabilities(String var1);

    @Nullable
    default public ColumnCapabilities capabilities(ColumnInspector inspector, String columnName) {
        return this.capabilities(columnName);
    }

    public List<String> requiredColumns();

    default public boolean usesDotNotation() {
        return false;
    }

    default public SelectableColumn toSelectableColumn(ColumnIndexSelector columnSelector) {
        return FeaturelessSelectableColumn.INSTANCE;
    }

    @Nullable
    default public ColumnIndexSupplier getIndexSupplier(String columnName, ColumnIndexSelector columnIndexSelector) {
        return NoIndexesColumnIndexSupplier.getInstance();
    }

    @Nullable
    default public EquivalenceKey getEquivalanceKey() {
        return null;
    }

    @SubclassesMustOverrideEqualsAndHashCode
    public static interface EquivalenceKey {
    }
}

