/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.VirtualColumns;

public class PostJoinCursor
implements Cursor {
    private final Cursor baseCursor;
    private final ColumnSelectorFactory columnSelectorFactory;
    @Nullable
    private ValueMatcher valueMatcher;
    @Nullable
    private final Filter postJoinFilter;

    private PostJoinCursor(Cursor baseCursor, VirtualColumns virtualColumns, @Nullable Filter filter) {
        this.baseCursor = baseCursor;
        this.columnSelectorFactory = virtualColumns.wrap(baseCursor.getColumnSelectorFactory());
        this.valueMatcher = filter == null ? null : filter.makeMatcher(this.columnSelectorFactory);
        this.postJoinFilter = filter;
    }

    public static PostJoinCursor wrap(Cursor baseCursor, VirtualColumns virtualColumns, @Nullable Filter filter) {
        PostJoinCursor postJoinCursor = new PostJoinCursor(baseCursor, virtualColumns, filter);
        postJoinCursor.advanceToMatch();
        return postJoinCursor;
    }

    @VisibleForTesting
    public void setValueMatcher(@Nullable ValueMatcher valueMatcher) {
        this.valueMatcher = valueMatcher;
    }

    private void advanceToMatch() {
        if (this.valueMatcher != null) {
            while (!this.isDone() && !this.valueMatcher.matches(false)) {
                this.baseCursor.advance();
            }
        }
    }

    @Override
    public ColumnSelectorFactory getColumnSelectorFactory() {
        return this.columnSelectorFactory;
    }

    @Nullable
    public Filter getPostJoinFilter() {
        return this.postJoinFilter;
    }

    @Override
    public void advance() {
        this.baseCursor.advance();
        this.advanceToMatch();
    }

    @Override
    public void advanceUninterruptibly() {
        this.advance();
    }

    @Override
    public boolean isDone() {
        return this.baseCursor.isDone();
    }

    @Override
    public boolean isDoneOrInterrupted() {
        return this.baseCursor.isDoneOrInterrupted();
    }

    @Override
    public void reset() {
        this.baseCursor.reset();
        this.advanceToMatch();
    }
}

