/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.RegexFilteredDimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;

public class RegexFilteredVirtualColumn
implements VirtualColumn {
    private final String name;
    private final DimensionSpec delegate;
    private final String pattern;

    @JsonCreator
    public RegexFilteredVirtualColumn(@JsonProperty(value="name") String name, @JsonProperty(value="delegate") DimensionSpec delegate, @JsonProperty(value="pattern") String pattern) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.delegate = (DimensionSpec)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.pattern = (String)Preconditions.checkNotNull((Object)pattern, (Object)"pattern");
    }

    @Override
    @JsonProperty(value="name")
    public String getOutputName() {
        return this.name;
    }

    @JsonProperty
    public String getPattern() {
        return this.pattern;
    }

    @JsonProperty
    public DimensionSpec getDelegate() {
        return this.delegate;
    }

    @Override
    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(4).appendString(this.name).appendCacheable(this.delegate).appendString(this.pattern);
        return builder.build();
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        return new RegexFilteredDimensionSpec(this.delegate, this.pattern).decorate(factory.makeDimensionSelector(this.delegate));
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        return this.makeDimensionSelector(DefaultDimensionSpec.of(columnName), factory);
    }

    @Override
    public ColumnCapabilities capabilities(String columnName) {
        return new ColumnCapabilitiesImpl().setType(this.delegate.getOutputType()).setDictionaryEncoded(true).setHasBitmapIndexes(true);
    }

    @Override
    @Nullable
    public ColumnCapabilities capabilities(ColumnInspector inspector, String columnName) {
        return inspector.getColumnCapabilities(this.delegate.getDimension());
    }

    @Override
    public List<String> requiredColumns() {
        return Collections.singletonList(this.delegate.getDimension());
    }

    @Override
    public boolean usesDotNotation() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexFilteredVirtualColumn that = (RegexFilteredVirtualColumn)o;
        return this.name.equals(that.name) && this.delegate.equals(that.delegate) && this.pattern.equals(that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.delegate, this.pattern);
    }

    public String toString() {
        return "RegexFilteredVirtualColumn{name='" + this.name + "', delegate=" + this.delegate + ", pattern='" + this.pattern + "'}";
    }
}

