/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.druid.segment.loading.LoadSpec;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.storage.azure.AzureDataSegmentPuller;

@JsonTypeName(value="azure")
public class AzureLoadSpec
implements LoadSpec {
    @JsonProperty
    private final String containerName;
    @JsonProperty
    private final String blobPath;
    private final AzureDataSegmentPuller puller;

    @JsonCreator
    public AzureLoadSpec(@JsonProperty(value="containerName") String containerName, @JsonProperty(value="blobPath") String blobPath, @JacksonInject AzureDataSegmentPuller puller) {
        Preconditions.checkNotNull((Object)blobPath);
        Preconditions.checkNotNull((Object)containerName);
        this.containerName = containerName;
        this.blobPath = blobPath;
        this.puller = puller;
    }

    public LoadSpec.LoadSpecResult loadSegment(File file) throws SegmentLoadingException {
        return new LoadSpec.LoadSpecResult(this.puller.getSegmentFiles(this.containerName, this.blobPath, file).size());
    }
}

