/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.Copy;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.util.Strings;
import io.kubernetes.client.util.exception.CopyNotSupportedException;
import java.io.IOException;
import java.nio.file.Paths;

public class KubectlCopy
extends Kubectl.ResourceAndContainerBuilder<V1Pod, KubectlCopy>
implements Kubectl.Executable<Boolean> {
    private String from;
    private String to;
    private Boolean toPod = null;
    private boolean dir;

    KubectlCopy() {
        super(V1Pod.class);
    }

    public KubectlCopy directory() {
        this.dir = true;
        return this;
    }

    public KubectlCopy from(String file) {
        this.from = file;
        return this;
    }

    public KubectlCopy fromPod(String fileInPod) {
        this.from = fileInPod;
        this.toPod = false;
        return this;
    }

    public KubectlCopy to(String file) {
        this.to = file;
        return this;
    }

    public KubectlCopy toPod(String fileInPod) {
        this.to = fileInPod;
        this.toPod = true;
        return this;
    }

    @Override
    public Boolean execute() throws KubectlException {
        this.validate();
        Copy cp = new Copy(this.apiClient);
        try {
            if (this.toPod.booleanValue()) {
                cp.copyFileToPod(this.namespace, this.name, this.container, Paths.get(this.from, new String[0]), Paths.get(this.to, new String[0]));
            } else if (this.dir) {
                cp.copyDirectoryFromPod(this.namespace, this.name, this.container, this.from, Paths.get(this.to, new String[0]));
            } else {
                cp.copyFileFromPod(this.namespace, this.name, this.container, this.from, Paths.get(this.to, new String[0]));
            }
            return true;
        }
        catch (ApiException | CopyNotSupportedException | IOException ex) {
            throw new KubectlException(ex);
        }
    }

    private void validate() throws KubectlException {
        if (this.toPod == null) {
            throw new KubectlException("You must specify either from or to a pod");
        }
        if (Strings.isNullOrEmpty((String)this.from)) {
            throw new KubectlException("From file missing");
        }
        if (Strings.isNullOrEmpty((String)this.to)) {
            throw new KubectlException("To file missing");
        }
    }
}

