/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka.supervisor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.data.input.kafka.KafkaRecordEntity;
import org.apache.druid.data.input.kafka.KafkaTopicPartition;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.kafka.KafkaDataSourceMetadata;
import org.apache.druid.indexing.kafka.KafkaIndexTask;
import org.apache.druid.indexing.kafka.KafkaIndexTaskClientFactory;
import org.apache.druid.indexing.kafka.KafkaIndexTaskIOConfig;
import org.apache.druid.indexing.kafka.KafkaIndexTaskTuningConfig;
import org.apache.druid.indexing.kafka.KafkaRecordSupplier;
import org.apache.druid.indexing.kafka.KafkaSequenceNumber;
import org.apache.druid.indexing.kafka.supervisor.KafkaSupervisorIOConfig;
import org.apache.druid.indexing.kafka.supervisor.KafkaSupervisorReportPayload;
import org.apache.druid.indexing.kafka.supervisor.KafkaSupervisorSpec;
import org.apache.druid.indexing.kafka.supervisor.KafkaSupervisorTuningConfig;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.LagStats;
import org.apache.druid.indexing.seekablestream.SeekableStreamEndSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTask;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClientFactory;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskIOConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskTuningConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamStartSequenceNumbers;
import org.apache.druid.indexing.seekablestream.common.OrderedPartitionableRecord;
import org.apache.druid.indexing.seekablestream.common.OrderedSequenceNumber;
import org.apache.druid.indexing.seekablestream.common.RecordSupplier;
import org.apache.druid.indexing.seekablestream.common.StreamException;
import org.apache.druid.indexing.seekablestream.common.StreamPartition;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisor;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorIOConfig;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorReportPayload;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.joda.time.DateTime;

public class KafkaSupervisor
extends SeekableStreamSupervisor<KafkaTopicPartition, Long, KafkaRecordEntity> {
    public static final TypeReference<TreeMap<Integer, Map<KafkaTopicPartition, Long>>> CHECKPOINTS_TYPE_REF = new TypeReference<TreeMap<Integer, Map<KafkaTopicPartition, Long>>>(){};
    private static final EmittingLogger log = new EmittingLogger(KafkaSupervisor.class);
    private static final Long NOT_SET = -1L;
    private static final Long END_OF_PARTITION = Long.MAX_VALUE;
    private final Pattern pattern;
    private volatile Map<KafkaTopicPartition, Long> latestSequenceFromStream;
    private volatile Map<KafkaTopicPartition, Long> partitionToTimeLag;
    private final KafkaSupervisorSpec spec;

    public KafkaSupervisor(TaskStorage taskStorage, TaskMaster taskMaster, IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator, KafkaIndexTaskClientFactory taskClientFactory, ObjectMapper mapper, KafkaSupervisorSpec spec, RowIngestionMetersFactory rowIngestionMetersFactory) {
        super(StringUtils.format((String)"KafkaSupervisor-%s", (Object[])new Object[]{spec.getId()}), taskStorage, taskMaster, indexerMetadataStorageCoordinator, (SeekableStreamIndexTaskClientFactory)taskClientFactory, mapper, (SeekableStreamSupervisorSpec)spec, rowIngestionMetersFactory, false);
        this.spec = spec;
        this.pattern = this.getIoConfig().isMultiTopic() ? Pattern.compile(this.getIoConfig().getStream()) : null;
    }

    protected RecordSupplier<KafkaTopicPartition, Long, KafkaRecordEntity> setupRecordSupplier() {
        return new KafkaRecordSupplier(this.spec.getIoConfig().getConsumerProperties(), this.sortingMapper, this.spec.getIoConfig().getConfigOverrides(), this.spec.getIoConfig().isMultiTopic());
    }

    protected int getTaskGroupIdForPartition(KafkaTopicPartition partitionId) {
        Integer taskCount = this.spec.getIoConfig().getTaskCount();
        if (partitionId.isMultiTopicPartition()) {
            return Math.abs(31 * partitionId.topic().hashCode() + partitionId.partition()) % taskCount;
        }
        return partitionId.partition() % taskCount;
    }

    protected boolean checkSourceMetadataMatch(DataSourceMetadata metadata) {
        return metadata instanceof KafkaDataSourceMetadata;
    }

    protected boolean doesTaskMatchSupervisor(Task task) {
        if (task instanceof KafkaIndexTask) {
            String supervisorId = ((KafkaIndexTask)task).getSupervisorId();
            return Objects.equal((Object)supervisorId, (Object)this.spec.getId());
        }
        return false;
    }

    protected SeekableStreamSupervisorReportPayload<KafkaTopicPartition, Long> createReportPayload(int numPartitions, boolean includeOffsets) {
        KafkaSupervisorIOConfig ioConfig = this.spec.getIoConfig();
        Map<KafkaTopicPartition, Long> partitionLag = this.getRecordLagPerPartitionInLatestSequences(this.getHighestCurrentOffsets());
        return new KafkaSupervisorReportPayload(this.spec.getId(), this.spec.getDataSchema().getDataSource(), ioConfig.getStream(), numPartitions, ioConfig.getReplicas(), ioConfig.getTaskDuration().getMillis() / 1000L, includeOffsets ? this.latestSequenceFromStream : null, includeOffsets ? partitionLag : null, includeOffsets ? this.getPartitionTimeLag() : null, includeOffsets ? Long.valueOf(this.aggregatePartitionLags(partitionLag).getTotalLag()) : null, includeOffsets ? this.sequenceLastUpdated : null, this.spec.isSuspended(), this.stateManager.isHealthy(), this.stateManager.getSupervisorState().getBasicState(), this.stateManager.getSupervisorState(), this.stateManager.getExceptionEvents());
    }

    protected SeekableStreamIndexTaskIOConfig createTaskIoConfig(int groupId, Map<KafkaTopicPartition, Long> startPartitions, Map<KafkaTopicPartition, Long> endPartitions, String baseSequenceName, DateTime minimumMessageTime, DateTime maximumMessageTime, Set<KafkaTopicPartition> exclusiveStartSequenceNumberPartitions, SeekableStreamSupervisorIOConfig ioConfig) {
        KafkaSupervisorIOConfig kafkaIoConfig = (KafkaSupervisorIOConfig)ioConfig;
        return new KafkaIndexTaskIOConfig(groupId, baseSequenceName, null, null, (SeekableStreamStartSequenceNumbers<KafkaTopicPartition, Long>)new SeekableStreamStartSequenceNumbers(kafkaIoConfig.getStream(), startPartitions, Collections.emptySet()), (SeekableStreamEndSequenceNumbers<KafkaTopicPartition, Long>)new SeekableStreamEndSequenceNumbers(kafkaIoConfig.getStream(), endPartitions), kafkaIoConfig.getConsumerProperties(), kafkaIoConfig.getPollTimeout(), true, minimumMessageTime, maximumMessageTime, ioConfig.getInputFormat(), kafkaIoConfig.getConfigOverrides(), kafkaIoConfig.isMultiTopic(), ioConfig.getTaskDuration().getStandardMinutes());
    }

    protected List<SeekableStreamIndexTask<KafkaTopicPartition, Long, KafkaRecordEntity>> createIndexTasks(int replicas, String baseSequenceName, ObjectMapper sortingMapper, TreeMap<Integer, Map<KafkaTopicPartition, Long>> sequenceOffsets, SeekableStreamIndexTaskIOConfig taskIoConfig, SeekableStreamIndexTaskTuningConfig taskTuningConfig, RowIngestionMetersFactory rowIngestionMetersFactory) throws JsonProcessingException {
        String checkpoints = sortingMapper.writerFor(CHECKPOINTS_TYPE_REF).writeValueAsString(sequenceOffsets);
        Map context = this.createBaseTaskContexts();
        context.put("checkpoints", checkpoints);
        ArrayList<SeekableStreamIndexTask<KafkaTopicPartition, Long, KafkaRecordEntity>> taskList = new ArrayList<SeekableStreamIndexTask<KafkaTopicPartition, Long, KafkaRecordEntity>>();
        for (int i = 0; i < replicas; ++i) {
            String taskId = IdUtils.getRandomIdWithPrefix((String)baseSequenceName);
            taskList.add(new KafkaIndexTask(taskId, this.spec.getId(), new TaskResource(baseSequenceName, 1), this.spec.getDataSchema(), (KafkaIndexTaskTuningConfig)taskTuningConfig, (KafkaIndexTaskIOConfig)taskIoConfig, context, sortingMapper));
        }
        return taskList;
    }

    protected Map<KafkaTopicPartition, Long> getPartitionRecordLag() {
        Set taskPartitions;
        Map highestCurrentOffsets = this.getHighestCurrentOffsets();
        if (this.latestSequenceFromStream == null) {
            return null;
        }
        Set<KafkaTopicPartition> kafkaPartitions = this.latestSequenceFromStream.keySet();
        if (!kafkaPartitions.equals(taskPartitions = highestCurrentOffsets.keySet())) {
            try {
                log.warn("Mismatched kafka and task partitions: Missing Task Partitions %s, Missing Kafka Partitions %s", new Object[]{this.sortingMapper.writeValueAsString((Object)Sets.difference(kafkaPartitions, taskPartitions)), this.sortingMapper.writeValueAsString((Object)Sets.difference(taskPartitions, kafkaPartitions))});
            }
            catch (JsonProcessingException e) {
                throw DruidException.defensive((String)"Failed to serialize KafkaTopicPartition when getting partition record lag: %s", (Object[])new Object[]{e.getMessage()});
            }
        }
        return this.getRecordLagPerPartitionInLatestSequences(highestCurrentOffsets);
    }

    @Nullable
    protected Map<KafkaTopicPartition, Long> getPartitionTimeLag() {
        return this.partitionToTimeLag;
    }

    private Map<KafkaTopicPartition, Long> getRecordLagPerPartitionInLatestSequences(Map<KafkaTopicPartition, Long> currentOffsets) {
        if (this.latestSequenceFromStream == null) {
            return Collections.emptyMap();
        }
        return this.latestSequenceFromStream.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? (Long)e.getValue() - Optional.ofNullable((Long)currentOffsets.get(e.getKey())).orElse(0L) : 0L));
    }

    protected Map<KafkaTopicPartition, Long> getRecordLagPerPartition(Map<KafkaTopicPartition, Long> currentOffsets) {
        if (this.latestSequenceFromStream == null || currentOffsets == null) {
            return Collections.emptyMap();
        }
        return currentOffsets.entrySet().stream().filter(e -> this.latestSequenceFromStream.get(e.getKey()) != null).collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? this.latestSequenceFromStream.get(e.getKey()) - (Long)e.getValue() : 0L));
    }

    protected Map<KafkaTopicPartition, Long> getTimeLagPerPartition(Map<KafkaTopicPartition, Long> currentOffsets) {
        return null;
    }

    protected KafkaDataSourceMetadata createDataSourceMetaDataForReset(String topic, Map<KafkaTopicPartition, Long> map) {
        return new KafkaDataSourceMetadata((SeekableStreamSequenceNumbers<KafkaTopicPartition, Long>)new SeekableStreamEndSequenceNumbers(topic, map));
    }

    protected OrderedSequenceNumber<Long> makeSequenceNumber(Long seq, boolean isExclusive) {
        return KafkaSequenceNumber.of(seq);
    }

    protected Long getNotSetMarker() {
        return NOT_SET;
    }

    protected Long getEndOfPartitionMarker() {
        return END_OF_PARTITION;
    }

    protected boolean isEndOfShard(Long seqNum) {
        return false;
    }

    protected boolean isShardExpirationMarker(Long seqNum) {
        return false;
    }

    protected boolean useExclusiveStartSequenceNumberForNonFirstSequence() {
        return false;
    }

    public LagStats computeLagStats() {
        Map<KafkaTopicPartition, Long> partitionRecordLag = this.getPartitionRecordLag();
        if (partitionRecordLag == null) {
            return new LagStats(0L, 0L, 0L);
        }
        return this.aggregatePartitionLags(partitionRecordLag);
    }

    private void updatePartitionTimeAndRecordLagFromStream() {
        Map highestCurrentOffsets = this.getHighestCurrentOffsets();
        this.getRecordSupplierLock().lock();
        try {
            Set partitionIds;
            try {
                partitionIds = this.recordSupplier.getPartitionIds(this.getIoConfig().getStream());
            }
            catch (Exception e2) {
                log.warn("Could not fetch partitions for topic/stream [%s]", new Object[]{this.getIoConfig().getStream()});
                throw new StreamException((Throwable)e2);
            }
            Set<StreamPartition<KafkaTopicPartition>> partitions = partitionIds.stream().map(e -> new StreamPartition(this.getIoConfig().getStream(), e)).collect(Collectors.toSet());
            HashSet<KafkaTopicPartition> yetToReadPartitions = new HashSet<KafkaTopicPartition>();
            for (KafkaTopicPartition partition : partitionIds) {
                Long highestCurrentOffset = (Long)highestCurrentOffsets.get(partition);
                if (highestCurrentOffset == null || highestCurrentOffset == 0L) {
                    yetToReadPartitions.add(partition);
                    continue;
                }
                this.recordSupplier.seek(new StreamPartition(this.getIoConfig().getStream(), (Object)partition), (Object)(highestCurrentOffset - 1L));
            }
            Map<KafkaTopicPartition, Long> lastIngestedTimestamps = this.getTimestampPerPartitionAtCurrentOffset(partitions);
            yetToReadPartitions.forEach(p -> lastIngestedTimestamps.put((KafkaTopicPartition)p, 0L));
            this.recordSupplier.seekToLatest(partitions);
            this.latestSequenceFromStream = this.recordSupplier.getLatestSequenceNumbers(partitions);
            for (Map.Entry<KafkaTopicPartition, Long> entry : this.latestSequenceFromStream.entrySet()) {
                if (entry.getValue() == 0L) continue;
                this.recordSupplier.seek(new StreamPartition(this.getIoConfig().getStream(), (Object)entry.getKey()), (Object)(entry.getValue() - 2L));
            }
            this.partitionToTimeLag = this.getTimestampPerPartitionAtCurrentOffset(partitions).entrySet().stream().filter(e -> lastIngestedTimestamps.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> (Long)e.getValue() - (Long)lastIngestedTimestamps.get(e.getKey())));
        }
        catch (InterruptedException e3) {
            throw new StreamException((Throwable)e3);
        }
        finally {
            this.getRecordSupplierLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<KafkaTopicPartition, Long> getTimestampPerPartitionAtCurrentOffset(Set<StreamPartition<KafkaTopicPartition>> allPartitions) {
        HashMap<KafkaTopicPartition, Long> result = new HashMap<KafkaTopicPartition, Long>();
        HashSet<StreamPartition<KafkaTopicPartition>> remainingPartitions = new HashSet<StreamPartition<KafkaTopicPartition>>(allPartitions);
        try {
            int maxPolls = 5;
            block3: while (!remainingPartitions.isEmpty() && maxPolls-- > 0) {
                for (OrderedPartitionableRecord record : this.recordSupplier.poll(this.getIoConfig().getPollTimeout())) {
                    if (!result.containsKey(record.getPartitionId())) {
                        result.put((KafkaTopicPartition)record.getPartitionId(), record.getTimestamp());
                        remainingPartitions.remove(new StreamPartition(this.getIoConfig().getStream(), (Object)((KafkaTopicPartition)record.getPartitionId())));
                        if (remainingPartitions.isEmpty()) continue block3;
                    }
                    this.recordSupplier.assign(remainingPartitions);
                }
            }
        }
        finally {
            this.recordSupplier.assign(allPartitions);
        }
        if (!remainingPartitions.isEmpty()) {
            log.info("Could not fetch the latest timestamp for partitions [%s].", new Object[]{remainingPartitions});
        }
        return result;
    }

    protected void updatePartitionLagFromStream() {
        if (this.getIoConfig().isEmitTimeLagMetrics()) {
            this.updatePartitionTimeAndRecordLagFromStream();
            return;
        }
        this.getRecordSupplierLock().lock();
        try {
            Set partitionIds;
            try {
                partitionIds = this.recordSupplier.getPartitionIds(this.getIoConfig().getStream());
            }
            catch (Exception e2) {
                log.warn("Could not fetch partitions for topic/stream [%s]", new Object[]{this.getIoConfig().getStream()});
                throw new StreamException((Throwable)e2);
            }
            Set partitions = partitionIds.stream().map(e -> new StreamPartition(this.getIoConfig().getStream(), e)).collect(Collectors.toSet());
            this.recordSupplier.seekToLatest(partitions);
            this.latestSequenceFromStream = partitions.stream().collect(Collectors.toMap(StreamPartition::getPartitionId, arg_0 -> ((RecordSupplier)this.recordSupplier).getPosition(arg_0)));
        }
        catch (InterruptedException e3) {
            throw new StreamException((Throwable)e3);
        }
        finally {
            this.getRecordSupplierLock().unlock();
        }
    }

    protected Map<KafkaTopicPartition, Long> getLatestSequencesFromStream() {
        return this.latestSequenceFromStream != null ? this.latestSequenceFromStream : new HashMap<KafkaTopicPartition, Long>();
    }

    protected String baseTaskName() {
        return "index_kafka";
    }

    @VisibleForTesting
    public KafkaSupervisorIOConfig getIoConfig() {
        return this.spec.getIoConfig();
    }

    @VisibleForTesting
    public KafkaSupervisorTuningConfig getTuningConfig() {
        return this.spec.getTuningConfig();
    }

    protected boolean isMultiTopic() {
        return this.getIoConfig().isMultiTopic() && this.pattern != null;
    }

    protected Map<KafkaTopicPartition, Long> getOffsetsFromMetadataStorage() {
        SeekableStreamSequenceNumbers partitions;
        DataSourceMetadata dataSourceMetadata = this.retrieveDataSourceMetadata();
        if (this.checkSourceMetadataMatch(dataSourceMetadata) && (partitions = ((KafkaDataSourceMetadata)dataSourceMetadata).getSeekableStreamSequenceNumbers()) != null && partitions.getPartitionSequenceNumberMap() != null) {
            HashMap<KafkaTopicPartition, Long> partitionOffsets = new HashMap<KafkaTopicPartition, Long>();
            HashSet topicMisMatchLogged = new HashSet();
            partitions.getPartitionSequenceNumberMap().forEach((kafkaTopicPartition, value) -> {
                String matchValue = kafkaTopicPartition.topic().isPresent() ? kafkaTopicPartition.topic().get() : partitions.getStream();
                KafkaTopicPartition matchingTopicPartition = this.getMatchingKafkaTopicPartition((KafkaTopicPartition)kafkaTopicPartition, matchValue);
                if (matchingTopicPartition == null && !topicMisMatchLogged.contains(matchValue)) {
                    log.warn("Topic/stream in metadata storage [%s] doesn't match spec topic/stream [%s], ignoring stored sequences", new Object[]{matchValue, this.getIoConfig().getStream()});
                    topicMisMatchLogged.add(matchValue);
                }
                if (matchingTopicPartition != null) {
                    partitionOffsets.put(matchingTopicPartition, (Long)value);
                }
            });
            return partitionOffsets;
        }
        return Collections.emptyMap();
    }

    @Nullable
    private KafkaTopicPartition getMatchingKafkaTopicPartition(KafkaTopicPartition kafkaTopicPartition, String streamMatchValue) {
        boolean match = this.pattern != null ? this.pattern.matcher(streamMatchValue).matches() : this.getIoConfig().getStream().equals(streamMatchValue);
        return match ? new KafkaTopicPartition(this.isMultiTopic(), streamMatchValue, kafkaTopicPartition.partition()) : null;
    }
}

