/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.multibindings.MapBinder;
import java.util.List;
import org.apache.druid.data.SearchableVersionedDataFinder;
import org.apache.druid.data.input.google.GoogleCloudStorageInputSource;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.google.GoogleAccountConfig;
import org.apache.druid.storage.google.GoogleDataSegmentKiller;
import org.apache.druid.storage.google.GoogleDataSegmentPusher;
import org.apache.druid.storage.google.GoogleInputDataConfig;
import org.apache.druid.storage.google.GoogleLoadSpec;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleTaskLogs;
import org.apache.druid.storage.google.GoogleTaskLogsConfig;
import org.apache.druid.storage.google.GoogleTimestampVersionedDataFinder;

public class GoogleStorageDruidModule
implements DruidModule {
    public static final String SCHEME = "google";
    public static final String SCHEME_GS = "gs";
    private static final Logger LOG = new Logger(GoogleStorageDruidModule.class);
    private static final String APPLICATION_NAME = "druid-google-extensions";

    public List<? extends Module> getJacksonModules() {
        LOG.info("Getting jackson modules...", new Object[0]);
        return ImmutableList.of((Object)new Module(){

            public String getModuleName() {
                return "Google-" + System.identityHashCode((Object)this);
            }

            public Version version() {
                return Version.unknownVersion();
            }

            public void setupModule(Module.SetupContext context) {
                context.registerSubtypes(new Class[]{GoogleLoadSpec.class});
            }
        }, (Object)new SimpleModule().registerSubtypes(new NamedType[]{new NamedType(GoogleCloudStorageInputSource.class, SCHEME)}));
    }

    public void configure(Binder binder) {
        LOG.info("Configuring GoogleStorageDruidModule...", new Object[0]);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.google", GoogleInputDataConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.google", GoogleAccountConfig.class);
        Binders.dataSegmentPusherBinder((Binder)binder).addBinding((Object)SCHEME).to(GoogleDataSegmentPusher.class).in(LazySingleton.class);
        Binders.dataSegmentKillerBinder((Binder)binder).addBinding((Object)SCHEME).to(GoogleDataSegmentKiller.class).in(LazySingleton.class);
        Binders.bindTaskLogs((Binder)binder, (String)SCHEME, GoogleTaskLogs.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.logs", GoogleTaskLogsConfig.class);
        binder.bind(GoogleTaskLogs.class).in(LazySingleton.class);
        MapBinder.newMapBinder((Binder)binder, String.class, SearchableVersionedDataFinder.class).addBinding((Object)SCHEME_GS).to(GoogleTimestampVersionedDataFinder.class).in(LazySingleton.class);
    }

    @Provides
    @LazySingleton
    public Storage getGcpStorage() {
        return (Storage)StorageOptions.getDefaultInstance().getService();
    }

    @Provides
    @LazySingleton
    public GoogleStorage getGoogleStorage(Provider<Storage> baseStorageProvider) {
        LOG.info("Building Cloud Storage Client...", new Object[0]);
        return new GoogleStorage((Supplier<Storage>)((Supplier)() -> baseStorageProvider.get()));
    }
}

