/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.java.util.common.IAE;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

public class HadoopyStringInputRowParser
implements InputRowParser<Object> {
    private final StringInputRowParser parser;

    public HadoopyStringInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec) {
        this.parser = new StringInputRowParser(parseSpec, null);
    }

    public List<InputRow> parseBatch(Object input) {
        if (input instanceof Text) {
            return ImmutableList.of((Object)this.parser.parse(((Text)input).toString()));
        }
        if (input instanceof BytesWritable) {
            BytesWritable valueBytes = (BytesWritable)input;
            return this.parser.parseBatch(ByteBuffer.wrap(valueBytes.getBytes(), 0, valueBytes.getLength()));
        }
        throw new IAE("can't convert type [%s] to InputRow", new Object[]{input.getClass().getName()});
    }

    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parser.getParseSpec();
    }

    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new HadoopyStringInputRowParser(parseSpec);
    }
}

