/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.run;

import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.error.DruidException;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.destination.IngestDestination;
import org.apache.druid.sql.http.QueryInfo;

public interface SqlEngine {
    public String name();

    public boolean featureAvailable(EngineFeature var1);

    public void validateContext(Map<String, Object> var1);

    public RelDataType resultTypeForSelect(RelDataTypeFactory var1, RelDataType var2, Map<String, Object> var3);

    public RelDataType resultTypeForInsert(RelDataTypeFactory var1, RelDataType var2, Map<String, Object> var3);

    public QueryMaker buildQueryMakerForSelect(RelRoot var1, PlannerContext var2) throws ValidationException;

    public QueryMaker buildQueryMakerForInsert(IngestDestination var1, RelRoot var2, PlannerContext var3) throws ValidationException;

    default public void initContextMap(Map<String, Object> contextMap) {
    }

    public SqlStatementFactory getSqlStatementFactory();

    default public List<QueryInfo> getRunningQueries(boolean selfOnly, AuthenticationResult authenticationResult, AuthorizationResult authorizationResult) {
        return List.of();
    }

    default public void cancelQuery(PlannerContext plannerContext, QueryScheduler queryScheduler) {
        throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.UNSUPPORTED).build("Engine[%s] does not support canceling queries", new Object[]{this.name()});
    }
}

