/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import java.util.Properties;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.PolyBind;
import org.apache.druid.guice.annotations.NativeQuery;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.sql.SqlLifecycleManager;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.SqlToolbox;
import org.apache.druid.sql.avatica.AvaticaModule;
import org.apache.druid.sql.calcite.aggregation.SqlAggregationModule;
import org.apache.druid.sql.calcite.expression.builtin.QueryLookupOperatorConversion;
import org.apache.druid.sql.calcite.planner.CalcitePlannerModule;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.run.NativeSqlEngine;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.schema.DruidCalciteSchemaModule;
import org.apache.druid.sql.calcite.schema.DruidSchemaManager;
import org.apache.druid.sql.calcite.schema.NoopDruidSchemaManager;
import org.apache.druid.sql.calcite.view.DruidViewModule;
import org.apache.druid.sql.calcite.view.NoopViewManager;
import org.apache.druid.sql.calcite.view.ViewManager;
import org.apache.druid.sql.guice.SqlBindings;
import org.apache.druid.sql.http.SqlHttpModule;

public class SqlModule
implements Module {
    public static final String PROPERTY_SQL_ENABLE = "druid.sql.enable";
    public static final String PROPERTY_SQL_ENABLE_JSON_OVER_HTTP = "druid.sql.http.enable";
    public static final String PROPERTY_SQL_ENABLE_AVATICA = "druid.sql.avatica.enable";
    public static final String PROPERTY_SQL_VIEW_MANAGER_TYPE = "druid.sql.viewmanager.type";
    public static final String PROPERTY_SQL_SCHEMA_MANAGER_TYPE = "druid.sql.schemamanager.type";
    public static final String PROPERTY_SQL_APPROX_COUNT_DISTINCT_CHOICE = "druid.sql.approxCountDistinct.function";
    private Properties props;

    @Inject
    public void setProps(Properties props) {
        this.props = props;
    }

    public void configure(Binder binder) {
        if (!this.isEnabled()) {
            return;
        }
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(ViewManager.class)).addBinding((Object)"noop").to(NoopViewManager.class).in(LazySingleton.class);
        PolyBind.createChoiceWithDefault((Binder)binder, (String)PROPERTY_SQL_VIEW_MANAGER_TYPE, (Key)Key.get(ViewManager.class), (String)"noop");
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(DruidSchemaManager.class)).addBinding((Object)"noop").to(NoopDruidSchemaManager.class).in(LazySingleton.class);
        PolyBind.createChoiceWithDefault((Binder)binder, (String)PROPERTY_SQL_SCHEMA_MANAGER_TYPE, (Key)Key.get(DruidSchemaManager.class), (String)"noop");
        binder.bind(TableDefnRegistry.class).in(LazySingleton.class);
        binder.install((Module)new DruidCalciteSchemaModule());
        binder.install((Module)new CalcitePlannerModule());
        binder.install((Module)new SqlAggregationModule());
        binder.install((Module)new DruidViewModule());
        binder.install((Module)new SqlStatementFactoryModule());
        SqlBindings.addOperatorConversion(binder, QueryLookupOperatorConversion.class);
        if (this.isJsonOverHttpEnabled()) {
            binder.install((Module)new SqlHttpModule());
        }
        if (this.isAvaticaEnabled()) {
            binder.install((Module)new AvaticaModule());
        }
        binder.bind(CatalogResolver.class).toInstance((Object)CatalogResolver.NULL_RESOLVER);
        Multibinder.newSetBinder((Binder)binder, SqlEngine.class).addBinding().to(NativeSqlEngine.class).in(LazySingleton.class);
    }

    private boolean isEnabled() {
        Preconditions.checkNotNull((Object)this.props, (Object)"props");
        return Boolean.valueOf(this.props.getProperty(PROPERTY_SQL_ENABLE, "true"));
    }

    private boolean isJsonOverHttpEnabled() {
        Preconditions.checkNotNull((Object)this.props, (Object)"props");
        return Boolean.valueOf(this.props.getProperty(PROPERTY_SQL_ENABLE_JSON_OVER_HTTP, "true"));
    }

    private boolean isAvaticaEnabled() {
        Preconditions.checkNotNull((Object)this.props, (Object)"props");
        return Boolean.valueOf(this.props.getProperty(PROPERTY_SQL_ENABLE_AVATICA, "true"));
    }

    public static class SqlStatementFactoryModule
    implements Module {
        @Provides
        @LazySingleton
        public SqlToolbox makeSqlToolbox(PlannerFactory plannerFactory, ServiceEmitter emitter, RequestLogger requestLogger, QueryScheduler queryScheduler, SqlLifecycleManager sqlLifecycleManager) {
            return new SqlToolbox(null, plannerFactory, emitter, requestLogger, queryScheduler, sqlLifecycleManager);
        }

        @Provides
        @NativeQuery
        @LazySingleton
        public SqlStatementFactory makeNativeSqlStatementFactory(NativeSqlEngine sqlEngine, SqlToolbox toolbox) {
            return new SqlStatementFactory(toolbox.withEngine(sqlEngine));
        }

        public void configure(Binder binder) {
        }
    }
}

