/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.realtime.ChatHandler;
import org.apache.druid.segment.realtime.ChatHandlerProvider;
import org.apache.druid.server.initialization.jetty.BadRequestException;
import org.apache.druid.server.initialization.jetty.ServiceUnavailableException;
import org.apache.druid.server.metrics.DataSourceTaskIdHolder;

@Path(value="/druid/worker/v1/chat")
public class ChatHandlerResource {
    public static final String TASK_ID_HEADER = "X-Druid-Task-Id";
    private final ChatHandlerProvider handlers;
    private final String taskId;

    @Inject
    public ChatHandlerResource(ChatHandlerProvider handlers, DataSourceTaskIdHolder taskIdHolder) {
        this.handlers = handlers;
        this.taskId = taskIdHolder.getTaskId();
    }

    @Path(value="/{id}")
    public Object doTaskChat(@PathParam(value="id") String handlerId, @Context HttpHeaders headers) {
        Optional<ChatHandler> handler;
        if (this.taskId != null) {
            String requestTaskId;
            List requestTaskIds = headers.getRequestHeader(TASK_ID_HEADER);
            String string = requestTaskId = requestTaskIds != null && !requestTaskIds.isEmpty() ? (String)Iterables.getOnlyElement((Iterable)requestTaskIds) : null;
            if (requestTaskId != null && !requestTaskId.equals(this.taskId) && !StringUtils.urlDecode((String)requestTaskId).equals(this.taskId)) {
                throw new BadRequestException(StringUtils.format((String)"Requested taskId[%s] doesn't match with taskId[%s]", (Object[])new Object[]{requestTaskId, this.taskId}));
            }
        }
        if ((handler = this.handlers.get(handlerId)).isPresent()) {
            return handler.get();
        }
        throw new ServiceUnavailableException(StringUtils.format((String)"Can't find chatHandler for handler[%s]", (Object[])new Object[]{handlerId}));
    }
}

