/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.druid.client.BrokerViewOfCoordinatorConfig;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.http.security.ConfigResourceFilter;

@Path(value="/druid-internal/v1/config")
public class BrokerDynamicConfigResource {
    private final BrokerViewOfCoordinatorConfig brokerViewOfCoordinatorConfig;

    @Inject
    public BrokerDynamicConfigResource(BrokerViewOfCoordinatorConfig brokerViewOfCoordinatorConfig) {
        this.brokerViewOfCoordinatorConfig = brokerViewOfCoordinatorConfig;
    }

    @GET
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    @Path(value="/coordinator")
    public Response getDynamicConfig() {
        return Response.ok((Object)this.brokerViewOfCoordinatorConfig.getDynamicConfig()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    @Path(value="/coordinator")
    public Response setDynamicConfig(CoordinatorDynamicConfig dynamicConfig) {
        this.brokerViewOfCoordinatorConfig.setDynamicConfig(dynamicConfig);
        return Response.ok().build();
    }
}

