/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.config;

import java.util.Objects;
import org.apache.druid.common.config.Configs;
import org.apache.druid.server.coordinator.config.MetadataCleanupConfig;
import org.joda.time.Duration;
import org.joda.time.Period;

public class KillUnusedSegmentsConfig
extends MetadataCleanupConfig {
    private final int maxSegments;
    private final Period maxInterval;
    private final boolean ignoreDurationToRetain;
    private final Duration bufferPeriod;

    public KillUnusedSegmentsConfig(Boolean cleanupEnabled, Duration cleanupPeriod, Duration durationToRetain, Boolean ignoreDurationToRetain, Duration bufferPeriod, Integer maxSegments, Period maxInterval) {
        super(Configs.valueOrDefault((Boolean)cleanupEnabled, (boolean)false), cleanupPeriod, durationToRetain);
        this.ignoreDurationToRetain = Configs.valueOrDefault((Boolean)ignoreDurationToRetain, (boolean)false);
        this.bufferPeriod = (Duration)Configs.valueOrDefault((Object)bufferPeriod, (Object)Duration.standardDays((long)30L));
        this.maxSegments = Configs.valueOrDefault((Integer)maxSegments, (int)100);
        this.maxInterval = (Period)Configs.valueOrDefault((Object)maxInterval, (Object)Period.days((int)30));
    }

    public int getMaxSegments() {
        return this.maxSegments;
    }

    public Period getMaxInterval() {
        return this.maxInterval;
    }

    public Duration getBufferPeriod() {
        return this.bufferPeriod;
    }

    public boolean isIgnoreDurationToRetain() {
        return this.ignoreDurationToRetain;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KillUnusedSegmentsConfig that = (KillUnusedSegmentsConfig)o;
        return this.maxSegments == that.maxSegments && this.ignoreDurationToRetain == that.ignoreDurationToRetain && Objects.equals(this.maxInterval, that.maxInterval) && Objects.equals(this.bufferPeriod, that.bufferPeriod);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxSegments, this.maxInterval, this.ignoreDurationToRetain, this.bufferPeriod);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Duration durationToRetain;
        private Duration cleanupPeriod;
        private Boolean ignoreDurationToRetain;
        private Duration bufferPeriod;
        private Integer maxSegments;
        private Period maxInterval;

        private Builder() {
        }

        public KillUnusedSegmentsConfig build() {
            return new KillUnusedSegmentsConfig(true, this.cleanupPeriod, this.durationToRetain, this.ignoreDurationToRetain, this.bufferPeriod, this.maxSegments, this.maxInterval);
        }

        public Builder withCleanupPeriod(Duration cleanupPeriod) {
            this.cleanupPeriod = cleanupPeriod;
            return this;
        }

        public Builder withDurationToRetain(Duration durationToRetain) {
            this.durationToRetain = durationToRetain;
            return this;
        }

        public Builder withIgnoreDurationToRetain(Boolean ignoreDurationToRetain) {
            this.ignoreDurationToRetain = ignoreDurationToRetain;
            return this;
        }

        public Builder withMaxSegmentsToKill(Integer maxSegments) {
            this.maxSegments = maxSegments;
            return this;
        }

        public Builder withMaxIntervalToKill(Period maxInterval) {
            this.maxInterval = maxInterval;
            return this;
        }

        public Builder withBufferPeriod(Duration bufferPeriod) {
            this.bufferPeriod = bufferPeriod;
            return this;
        }
    }
}

