/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.druid.client.DruidServerConfig;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.druid.server.metrics.SegmentRowCountDistribution;

@LoadScope(roles={"historical"})
public class SegmentStatsMonitor
extends AbstractMonitor {
    private final DruidServerConfig serverConfig;
    private final SegmentLoadDropHandler segmentLoadDropHandler;
    private static final Logger log = new Logger(SegmentStatsMonitor.class);

    @Inject
    public SegmentStatsMonitor(DruidServerConfig serverConfig, SegmentLoadDropHandler segmentLoadDropHandler, SegmentLoaderConfig segmentLoaderConfig) {
        if (segmentLoaderConfig.isLazyLoadOnStart()) {
            log.error("Monitor doesn't support working with lazy loading on start", new Object[0]);
            throw new IllegalStateException("Monitor doesn't support working with lazy loading on start");
        }
        this.serverConfig = serverConfig;
        this.segmentLoadDropHandler = segmentLoadDropHandler;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        String dataSource;
        for (Map.Entry<String, Long> entry : this.segmentLoadDropHandler.getAverageNumOfRowsPerSegmentForDatasource().entrySet()) {
            dataSource = entry.getKey();
            long averageSize = entry.getValue();
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("dataSource", (Object)dataSource).setDimension("tier", (Object)this.serverConfig.getTier()).setDimension("priority", (Object)String.valueOf(this.serverConfig.getPriority()));
            emitter.emit((ServiceEventBuilder)builder.setMetric("segment/rowCount/avg", (Number)averageSize));
        }
        for (Map.Entry<String, Object> entry : this.segmentLoadDropHandler.getRowCountDistributionPerDatasource().entrySet()) {
            dataSource = entry.getKey();
            SegmentRowCountDistribution rowCountBucket = (SegmentRowCountDistribution)entry.getValue();
            rowCountBucket.forEachDimension((bucketDimension, count) -> {
                ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("dataSource", (Object)dataSource).setDimension("tier", (Object)this.serverConfig.getTier()).setDimension("priority", (Object)String.valueOf(this.serverConfig.getPriority()));
                builder.setDimension("range", bucketDimension);
                ServiceMetricEvent.Builder output = builder.setMetric("segment/rowCount/range/count", (Number)count);
                emitter.emit((ServiceEventBuilder)output);
            });
        }
        return true;
    }
}

