/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1alpha2PodSchedulingContextSpec;
import io.kubernetes.client.openapi.models.V1alpha2PodSchedulingContextSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha2PodSchedulingContextSpecFluentImpl<A extends V1alpha2PodSchedulingContextSpecFluent<A>>
extends BaseFluent<A>
implements V1alpha2PodSchedulingContextSpecFluent<A> {
    private List<String> potentialNodes;
    private String selectedNode;

    public V1alpha2PodSchedulingContextSpecFluentImpl() {
    }

    public V1alpha2PodSchedulingContextSpecFluentImpl(V1alpha2PodSchedulingContextSpec instance) {
        if (instance != null) {
            this.withPotentialNodes(instance.getPotentialNodes());
            this.withSelectedNode(instance.getSelectedNode());
        }
    }

    @Override
    public A addToPotentialNodes(int index, String item) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        this.potentialNodes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPotentialNodes(int index, String item) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        this.potentialNodes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPotentialNodes(String ... items) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.potentialNodes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPotentialNodes(Collection<String> items) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.potentialNodes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPotentialNodes(String ... items) {
        for (String item : items) {
            if (this.potentialNodes == null) continue;
            this.potentialNodes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPotentialNodes(Collection<String> items) {
        for (String item : items) {
            if (this.potentialNodes == null) continue;
            this.potentialNodes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPotentialNodes() {
        return this.potentialNodes;
    }

    @Override
    public String getPotentialNode(int index) {
        return this.potentialNodes.get(index);
    }

    @Override
    public String getFirstPotentialNode() {
        return this.potentialNodes.get(0);
    }

    @Override
    public String getLastPotentialNode() {
        return this.potentialNodes.get(this.potentialNodes.size() - 1);
    }

    @Override
    public String getMatchingPotentialNode(Predicate<String> predicate) {
        for (String item : this.potentialNodes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPotentialNode(Predicate<String> predicate) {
        for (String item : this.potentialNodes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPotentialNodes(List<String> potentialNodes) {
        if (potentialNodes != null) {
            this.potentialNodes = new ArrayList<String>();
            for (String item : potentialNodes) {
                this.addToPotentialNodes(item);
            }
        } else {
            this.potentialNodes = null;
        }
        return (A)this;
    }

    @Override
    public A withPotentialNodes(String ... potentialNodes) {
        if (this.potentialNodes != null) {
            this.potentialNodes.clear();
            this._visitables.remove("potentialNodes");
        }
        if (potentialNodes != null) {
            for (String item : potentialNodes) {
                this.addToPotentialNodes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPotentialNodes() {
        return this.potentialNodes != null && !this.potentialNodes.isEmpty();
    }

    @Override
    public String getSelectedNode() {
        return this.selectedNode;
    }

    @Override
    public A withSelectedNode(String selectedNode) {
        this.selectedNode = selectedNode;
        return (A)this;
    }

    @Override
    public Boolean hasSelectedNode() {
        return this.selectedNode != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha2PodSchedulingContextSpecFluentImpl that = (V1alpha2PodSchedulingContextSpecFluentImpl)o;
        if (!Objects.equals(this.potentialNodes, that.potentialNodes)) {
            return false;
        }
        return Objects.equals(this.selectedNode, that.selectedNode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.potentialNodes, this.selectedNode, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.potentialNodes != null && !this.potentialNodes.isEmpty()) {
            sb.append("potentialNodes:");
            sb.append(this.potentialNodes + ",");
        }
        if (this.selectedNode != null) {
            sb.append("selectedNode:");
            sb.append(this.selectedNode);
        }
        sb.append("}");
        return sb.toString();
    }
}

