/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.util.ProjectionMath;

public class Eckert4Projection
extends Projection {
    private static final double C_x = 0.4222382003157712;
    private static final double C_y = 1.3265004281770023;
    private static final double RC_y = 0.7538633073600218;
    private static final double C_p = 3.5707963267948966;
    private static final double RC_p = 0.2800495767557787;
    private static final double EPS = 1.0E-7;
    private final int NITER = 6;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        int i;
        double p = 3.5707963267948966 * Math.sin(lpphi);
        double V = lpphi * lpphi;
        lpphi *= 0.895168 + V * (0.0218849 + V * 0.00826809);
        for (i = 6; i > 0; --i) {
            double c = Math.cos(lpphi);
            double s = Math.sin(lpphi);
            V = (lpphi + s * (c + 2.0) - p) / (1.0 + c * (c + 2.0) - s * s);
            lpphi -= V;
            if (Math.abs(V) < 1.0E-7) break;
        }
        if (i == 0) {
            out.x = 0.4222382003157712 * lplam;
            out.y = lpphi < 0.0 ? -1.3265004281770023 : 1.3265004281770023;
        } else {
            out.x = 0.4222382003157712 * lplam * (1.0 + Math.cos(lpphi));
            out.y = 1.3265004281770023 * Math.sin(lpphi);
        }
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out.y = ProjectionMath.asin(xyy / 1.3265004281770023);
        double c = Math.cos(out.y);
        out.x = xyx / (0.4222382003157712 * (1.0 + c));
        out.y = ProjectionMath.asin((out.y + Math.sin(out.y) * (c + 2.0)) / 3.5707963267948966);
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public String toString() {
        return "Eckert IV";
    }
}

