/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.counters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.msq.counters.QueryCounter;
import org.apache.druid.msq.counters.QueryCounterSnapshot;
import org.apache.druid.utils.JvmUtils;

public class CpuCounter
implements QueryCounter {
    private final AtomicLong cpuTime = new AtomicLong();
    private final AtomicLong wallTime = new AtomicLong();

    public void accumulate(long cpu, long wall) {
        this.cpuTime.addAndGet(cpu);
        this.wallTime.addAndGet(wall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> void run(Doer<E> doer) throws E {
        long startCpu = JvmUtils.getCurrentThreadCpuTime();
        long startWall = System.nanoTime();
        try {
            doer.run();
        }
        finally {
            this.accumulate(JvmUtils.getCurrentThreadCpuTime() - startCpu, System.nanoTime() - startWall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T run(Returner<T, E> returner) throws E {
        long startCpu = JvmUtils.getCurrentThreadCpuTime();
        long startWall = System.nanoTime();
        try {
            T t = returner.run();
            return t;
        }
        finally {
            this.accumulate(JvmUtils.getCurrentThreadCpuTime() - startCpu, System.nanoTime() - startWall);
        }
    }

    @Override
    public Snapshot snapshot() {
        return new Snapshot(this.cpuTime.get(), this.wallTime.get());
    }

    public static interface Doer<E extends Throwable> {
        public void run() throws E;
    }

    public static interface Returner<T, E extends Throwable> {
        public T run() throws E;
    }

    @JsonTypeName(value="cpu")
    public static class Snapshot
    implements QueryCounterSnapshot {
        private final long cpuTime;
        private final long wallTime;

        @JsonCreator
        public Snapshot(@JsonProperty(value="cpu") long cpuTime, @JsonProperty(value="wall") long wallTime) {
            this.cpuTime = cpuTime;
            this.wallTime = wallTime;
        }

        @JsonProperty(value="cpu")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public long getCpuTime() {
            return this.cpuTime;
        }

        @JsonProperty(value="wall")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public long getWallTime() {
            return this.wallTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Snapshot snapshot = (Snapshot)o;
            return this.cpuTime == snapshot.cpuTime && this.wallTime == snapshot.wallTime;
        }

        public int hashCode() {
            return Objects.hash(this.cpuTime, this.wallTime);
        }

        public String toString() {
            return "CpuCounter.Snapshot{cpuTime=" + this.cpuTime + ", wallTime=" + this.wallTime + "}";
        }
    }
}

