/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.sql;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.error.DruidException;
import org.apache.druid.io.LimitedOutputStream;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.dart.controller.ControllerHolder;
import org.apache.druid.msq.dart.controller.DartControllerContextFactory;
import org.apache.druid.msq.dart.controller.DartControllerRegistry;
import org.apache.druid.msq.dart.guice.DartControllerConfig;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.exec.ControllerContext;
import org.apache.druid.msq.exec.ControllerImpl;
import org.apache.druid.msq.exec.QueryKitSpecFactory;
import org.apache.druid.msq.exec.QueryListener;
import org.apache.druid.msq.exec.ResultsContext;
import org.apache.druid.msq.indexing.LegacyMSQSpec;
import org.apache.druid.msq.indexing.QueryDefMSQSpec;
import org.apache.druid.msq.indexing.TaskReportQueryListener;
import org.apache.druid.msq.indexing.destination.TaskReportMSQDestination;
import org.apache.druid.msq.indexing.error.CanceledFault;
import org.apache.druid.msq.indexing.error.CancellationReason;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.indexing.report.MSQResultsReport;
import org.apache.druid.msq.indexing.report.MSQStatusReport;
import org.apache.druid.msq.indexing.report.MSQTaskReportPayload;
import org.apache.druid.msq.sql.MSQTaskQueryMaker;
import org.apache.druid.query.QueryContext;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.sql.calcite.planner.ColumnMappings;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.QueryUtils;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.SqlResults;

public class DartQueryMaker
implements QueryMaker {
    private static final Logger log = new Logger(DartQueryMaker.class);
    final List<Map.Entry<Integer, String>> fieldMapping;
    private final DartControllerContextFactory controllerContextFactory;
    private final PlannerContext plannerContext;
    private final DartControllerRegistry controllerRegistry;
    private final DartControllerConfig controllerConfig;
    private final ExecutorService controllerExecutor;
    private final ServerConfig serverConfig;
    final QueryKitSpecFactory queryKitSpecFactory;

    public DartQueryMaker(List<Map.Entry<Integer, String>> fieldMapping, DartControllerContextFactory controllerContextFactory, PlannerContext plannerContext, DartControllerRegistry controllerRegistry, DartControllerConfig controllerConfig, ExecutorService controllerExecutor, QueryKitSpecFactory queryKitSpecFactory, ServerConfig serverConfig) {
        this.fieldMapping = fieldMapping;
        this.controllerContextFactory = controllerContextFactory;
        this.plannerContext = plannerContext;
        this.controllerRegistry = controllerRegistry;
        this.controllerConfig = controllerConfig;
        this.controllerExecutor = controllerExecutor;
        this.queryKitSpecFactory = queryKitSpecFactory;
        this.serverConfig = serverConfig;
    }

    public QueryResponse<Object[]> runQuery(DruidQuery druidQuery) {
        ColumnMappings columnMappings = QueryUtils.buildColumnMappings(this.fieldMapping, (RowSignature)druidQuery.getOutputRowSignature());
        LegacyMSQSpec querySpec = MSQTaskQueryMaker.makeLegacyMSQSpec(null, druidQuery, this.finalizeTimeout(druidQuery.getQuery().context()), columnMappings, this.plannerContext, null);
        ResultsContext resultsContext = MSQTaskQueryMaker.makeResultsContext(druidQuery, this.fieldMapping, this.plannerContext);
        return this.runLegacyMSQSpec(querySpec, druidQuery.getQuery().context(), resultsContext);
    }

    public static ResultsContext makeResultsContext(DruidQuery druidQuery, List<Map.Entry<Integer, String>> fieldMapping, PlannerContext plannerContext) {
        List<Pair<SqlTypeName, ColumnType>> types = MSQTaskQueryMaker.getTypes(druidQuery, fieldMapping, plannerContext);
        ResultsContext resultsContext = new ResultsContext(types.stream().map(p -> (SqlTypeName)p.lhs).collect(Collectors.toList()), SqlResults.Context.fromPlannerContext((PlannerContext)plannerContext));
        return resultsContext;
    }

    private ControllerImpl makeLegacyController(LegacyMSQSpec querySpec, QueryContext context, ResultsContext resultsContext) {
        ControllerContext controllerContext = this.controllerContextFactory.newContext(context);
        return new ControllerImpl(querySpec, resultsContext, controllerContext, this.queryKitSpecFactory);
    }

    private ControllerImpl makeQueryDefController(QueryDefMSQSpec querySpec, QueryContext context, ResultsContext resultsContext) {
        ControllerContext controllerContext = this.controllerContextFactory.newContext(context);
        return new ControllerImpl(querySpec, resultsContext, controllerContext, this.queryKitSpecFactory);
    }

    public QueryResponse<Object[]> runLegacyMSQSpec(LegacyMSQSpec querySpec, QueryContext context, ResultsContext resultsContext) {
        ControllerImpl controller = this.makeLegacyController(querySpec, context, resultsContext);
        return this.runController(controller, context.getFullReport());
    }

    public QueryResponse<Object[]> runQueryDefMSQSpec(QueryDefMSQSpec querySpec, QueryContext context, ResultsContext resultsContext) {
        ControllerImpl controller = this.makeQueryDefController(querySpec, context, resultsContext);
        return this.runController(controller, context.getFullReport());
    }

    private QueryResponse<Object[]> runController(ControllerImpl controller, boolean fullReport) {
        ControllerHolder controllerHolder = new ControllerHolder(controller, this.plannerContext.getSqlQueryId(), this.plannerContext.getSql(), this.plannerContext.getAuthenticationResult(), DateTimes.nowUtc());
        this.controllerRegistry.register(controllerHolder);
        try {
            Sequence<Object[]> results = fullReport ? this.runWithReport(controllerHolder) : this.runWithoutReport(controllerHolder);
            return QueryResponse.withEmptyContext(results);
        }
        catch (Throwable e) {
            this.controllerRegistry.deregister(controllerHolder);
            throw e;
        }
    }

    private QueryContext finalizeTimeout(QueryContext queryContext) {
        long timeout = queryContext.getTimeout(this.serverConfig.getDefaultQueryTimeout());
        QueryContext timeoutContext = queryContext.override(Map.of("timeout", timeout));
        timeoutContext.verifyMaxQueryTimeout(this.serverConfig.getMaxQueryTimeout());
        return timeoutContext;
    }

    private Sequence<Object[]> runWithReport(ControllerHolder controllerHolder) {
        final Future<Map> reportFuture = this.controllerExecutor.submit(() -> {
            String threadName = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName(this.nameThread(this.plannerContext));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                TaskReportQueryListener queryListener = new TaskReportQueryListener(TaskReportMSQDestination.instance(), () -> new LimitedOutputStream((OutputStream)baos, (long)this.controllerConfig.getMaxQueryReportSize(), limit -> StringUtils.format((String)"maxQueryReportSize[%,d] exceeded. Try limiting the result set for your query, or run it with %s[false]", (Object[])new Object[]{limit, "fullReport"})), this.plannerContext.getJsonMapper(), controllerHolder.getController().queryId(), Collections.emptyMap());
                if (controllerHolder.run(queryListener)) {
                    Map map = (Map)this.plannerContext.getJsonMapper().readValue(baos.toByteArray(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
                    return map;
                }
                throw MSQErrorReport.fromFault(controllerHolder.getController().queryId(), null, null, CanceledFault.userRequest()).toDruidException();
            }
            finally {
                this.controllerRegistry.deregister(controllerHolder);
                Thread.currentThread().setName(threadName);
            }
        });
        return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Object[], Iterator<Object[]>>(){

            public Iterator<Object[]> make() {
                try {
                    return Iterators.singletonIterator((Object)new Object[]{reportFuture.get()});
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    Throwables.throwIfUnchecked((Throwable)e.getCause());
                    throw new RuntimeException(e.getCause());
                }
            }

            public void cleanup(Iterator<Object[]> iterFromMake) {
            }
        });
    }

    private Sequence<Object[]> runWithoutReport(ControllerHolder controllerHolder) {
        return new BaseSequence((BaseSequence.IteratorMaker)new ResultIteratorMaker(controllerHolder));
    }

    private String nameThread(PlannerContext plannerContext) {
        return StringUtils.format((String)"%s-sqlQueryId[%s]-queryId[%s]", (Object[])new Object[]{Thread.currentThread().getName(), plannerContext.getSqlQueryId(), plannerContext.queryContext().get("dartQueryId")});
    }

    class ResultIteratorMaker
    implements BaseSequence.IteratorMaker<Object[], ResultIterator> {
        private final ControllerHolder controllerHolder;
        private final ResultIterator resultIterator;
        private boolean made;

        public ResultIteratorMaker(ControllerHolder holder) {
            this.controllerHolder = holder;
            this.resultIterator = new ResultIterator(this.controllerHolder.getController().getQueryContext().getTimeoutDuration());
            this.submitController();
        }

        private void submitController() {
            DartQueryMaker.this.controllerExecutor.submit(() -> {
                Controller controller = this.controllerHolder.getController();
                String threadName = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName(DartQueryMaker.this.nameThread(DartQueryMaker.this.plannerContext));
                    if (!this.controllerHolder.run(this.resultIterator)) {
                        this.resultIterator.pushError((Throwable)MSQErrorReport.fromFault(this.controllerHolder.getController().queryId(), null, null, CanceledFault.userRequest()).toDruidException());
                    }
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Controller failed for sqlQueryId[%s], controllerHost[%s]", new Object[]{DartQueryMaker.this.plannerContext.getSqlQueryId(), controller.queryId()});
                }
                catch (Throwable e) {
                    log.error(e, "Controller failed for sqlQueryId[%s], controllerHost[%s]", new Object[]{DartQueryMaker.this.plannerContext.getSqlQueryId(), controller.queryId()});
                    throw e;
                }
                finally {
                    DartQueryMaker.this.controllerRegistry.deregister(this.controllerHolder);
                    Thread.currentThread().setName(threadName);
                }
            });
        }

        public ResultIterator make() {
            if (this.made) {
                throw new ISE("Cannot call make() more than once", new Object[0]);
            }
            this.made = true;
            return this.resultIterator;
        }

        public void cleanup(ResultIterator iterFromMake) {
            if (!iterFromMake.complete) {
                this.controllerHolder.cancel(CancellationReason.UNKNOWN);
            }
        }
    }

    static class ResultIterator
    implements Iterator<Object[]>,
    QueryListener {
        private static final int BUFFER_SIZE = 128;
        private final BlockingQueue<Either<Throwable, Object[]>> rowBuffer = new ArrayBlockingQueue<Either<Throwable, Object[]>>(128);
        @Nullable
        private Either<Throwable, Object[]> current;
        private volatile boolean complete;
        @Nullable
        private final Duration timeout;

        public ResultIterator(@Nullable Duration timeout) {
            this.timeout = timeout;
        }

        @Override
        public boolean hasNext() {
            return this.populateAndReturnCurrent().isPresent();
        }

        @Override
        public Object[] next() {
            Object[] retVal = this.populateAndReturnCurrent().orElseThrow(NoSuchElementException::new);
            this.current = null;
            return retVal;
        }

        private Optional<Object[]> populateAndReturnCurrent() {
            if (this.current == null) {
                try {
                    if (this.timeout != null) {
                        this.current = this.rowBuffer.poll(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
                        if (this.current == null) {
                            throw DruidException.defensive((String)"Result reader timed out [%s]", (Object[])new Object[]{this.timeout});
                        }
                    } else {
                        this.current = this.rowBuffer.take();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            if (this.current.isValue()) {
                return Optional.ofNullable((Object[])this.current.valueOrThrow());
            }
            Throwable e = (Throwable)this.current.error();
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }

        @Override
        public boolean readResults() {
            return !this.complete;
        }

        @Override
        public void onResultsStart(List<MSQResultsReport.ColumnAndType> signature, @Nullable List<SqlTypeName> sqlTypeNames) {
        }

        @Override
        public boolean onResultRow(Object[] row) {
            try {
                this.rowBuffer.put((Either<Throwable, Object[]>)Either.value((Object)row));
                return !this.complete;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        @Override
        public void onResultsComplete() {
        }

        @Override
        public void onQueryComplete(MSQTaskReportPayload report) {
            try {
                this.complete = true;
                MSQStatusReport statusReport = report.getStatus();
                if (statusReport.getStatus().isSuccess()) {
                    this.rowBuffer.put((Either<Throwable, Object[]>)Either.value(null));
                } else {
                    this.pushError((Throwable)statusReport.getErrorReport().toDruidException());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        public void pushError(Throwable e) throws InterruptedException {
            this.rowBuffer.put((Either<Throwable, Object[]>)Either.error((Object)e));
        }
    }
}

