/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import java.io.IOException;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.PartitionedOutputChannel;

public class ListeningOutputChannelFactory
implements OutputChannelFactory {
    private final OutputChannelFactory delegate;
    private final Listener listener;

    public ListeningOutputChannelFactory(OutputChannelFactory delegate, Listener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    public OutputChannel openChannel(int partitionNumber) throws IOException {
        return this.notifyListener(this.delegate.openChannel(partitionNumber));
    }

    public OutputChannel openNilChannel(int partitionNumber) {
        return this.notifyListener(this.delegate.openNilChannel(partitionNumber));
    }

    public PartitionedOutputChannel openPartitionedChannel(String name, boolean deleteAfterRead) {
        throw new UnsupportedOperationException("Listening to partitioned channels is not supported");
    }

    public boolean isBuffered() {
        return this.delegate.isBuffered();
    }

    private OutputChannel notifyListener(OutputChannel channel) {
        this.listener.channelOpened(channel);
        return channel;
    }

    public static interface Listener {
        public void channelOpened(OutputChannel var1);
    }
}

