/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.math.RoundingMode;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.TooManyClusteredByColumnsFault;
import org.apache.druid.msq.indexing.error.TooManyColumnsFault;
import org.apache.druid.msq.indexing.error.TooManyInputFilesFault;
import org.apache.druid.msq.indexing.error.TooManyWorkersFault;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.WorkOrder;

public class QueryValidator {
    public static void validateQueryDef(QueryDefinition queryDef) {
        for (StageDefinition stageDef : queryDef.getStageDefinitions()) {
            int numColumns = stageDef.getSignature().size();
            if (numColumns > 2000) {
                throw new MSQException(new TooManyColumnsFault(numColumns, 2000));
            }
            int numClusteredByColumns = stageDef.getClusterBy().getColumns().size();
            if (numClusteredByColumns > 1500) {
                throw new MSQException(new TooManyClusteredByColumnsFault(numClusteredByColumns, 1500, stageDef.getStageNumber()));
            }
            int numWorkers = stageDef.getMaxWorkerCount();
            if (numWorkers > 1000) {
                throw new MSQException(new TooManyWorkersFault(numWorkers, 1000));
            }
            if (numWorkers > 0) continue;
            throw new ISE("Number of workers must be greater than 0", new Object[0]);
        }
    }

    public static void validateWorkOrder(WorkOrder order) {
        int numInputFiles = Ints.checkedCast((long)order.getInputs().stream().mapToLong(InputSlice::fileCount).sum());
        if (numInputFiles > 10000) {
            throw new MSQException(new TooManyInputFilesFault(numInputFiles, 10000, IntMath.divide((int)numInputFiles, (int)10000, (RoundingMode)RoundingMode.CEILING)));
        }
    }
}

