/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle.input;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.druid.frame.channel.ReadableByteChunksFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.indexing.InputChannelFactory;
import org.apache.druid.msq.kernel.StageId;

public class WorkerInputChannelFactory
implements InputChannelFactory {
    private final WorkerClient workerClient;
    private final Supplier<List<String>> taskList;

    public WorkerInputChannelFactory(WorkerClient workerClient, Supplier<List<String>> taskList) {
        this.workerClient = (WorkerClient)Preconditions.checkNotNull((Object)workerClient, (Object)"workerClient");
        this.taskList = (Supplier)Preconditions.checkNotNull(taskList, (Object)"taskList");
    }

    @Override
    public ReadableFrameChannel openChannel(StageId stageId, int workerNumber, int partitionNumber) {
        String taskId = this.taskList.get().get(workerNumber);
        ReadableByteChunksFrameChannel channel = ReadableByteChunksFrameChannel.create((String)WorkerInputChannelFactory.makeChannelId(taskId, stageId, partitionNumber), (boolean)false);
        this.fetch(taskId, stageId, partitionNumber, 0L, channel);
        return channel;
    }

    private void fetch(final String taskId, final StageId stageId, final int partitionNumber, long offset, final ReadableByteChunksFrameChannel channel) {
        ListenableFuture<Boolean> fetchFuture = this.workerClient.fetchChannelData(taskId, stageId, partitionNumber, offset, channel);
        Futures.addCallback(fetchFuture, (FutureCallback)new FutureCallback<Boolean>(){

            public void onSuccess(Boolean lastFetch) {
                if (lastFetch.booleanValue()) {
                    channel.doneWriting();
                } else {
                    WorkerInputChannelFactory.this.fetch(taskId, stageId, partitionNumber, channel.getBytesAdded(), channel);
                }
            }

            public void onFailure(Throwable t) {
                channel.setError(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static String makeChannelId(String workerTaskId, StageId stageId, int partitionNumber) {
        return StringUtils.format((String)"%s:%s:%s", (Object[])new Object[]{workerTaskId, stageId, partitionNumber});
    }
}

