/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import org.apache.datasketches.hll.HllSketch;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskReport;
import org.joda.time.Interval;

public class DimensionCardinalityReport
implements SubTaskReport {
    public static final int HLL_SKETCH_LOG_K = 11;
    static final String TYPE = "dimension_cardinality";
    private static final String PROP_CARDINALITIES = "cardinalities";
    private final String taskId;
    private final Map<Interval, byte[]> intervalToCardinalities;

    @JsonCreator
    public DimensionCardinalityReport(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="cardinalities") Map<Interval, byte[]> intervalToCardinalities) {
        this.taskId = taskId;
        this.intervalToCardinalities = intervalToCardinalities;
    }

    @Override
    @JsonProperty
    public String getTaskId() {
        return this.taskId;
    }

    @JsonProperty(value="cardinalities")
    public Map<Interval, byte[]> getIntervalToCardinalities() {
        return this.intervalToCardinalities;
    }

    public String toString() {
        return "DimensionCardinalityReport{taskId='" + this.taskId + "', intervalToCardinalities=" + this.intervalToCardinalities + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionCardinalityReport that = (DimensionCardinalityReport)o;
        return Objects.equals(this.getTaskId(), that.getTaskId()) && Objects.equals(this.getIntervalToCardinalities(), that.getIntervalToCardinalities());
    }

    public int hashCode() {
        return Objects.hash(this.getTaskId(), this.getIntervalToCardinalities());
    }

    public static HllSketch createHllSketchForReport() {
        return new HllSketch(11);
    }
}

