/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.indexer.granularity.ArbitraryGranularitySpec;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractBatchSubtask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

abstract class PerfectRollupWorkerTask
extends AbstractBatchSubtask {
    private final GranularitySpec granularitySpec;
    private final DataSchema dataSchema;
    private final ParallelIndexTuningConfig tuningConfig;

    PerfectRollupWorkerTask(String id, @Nullable String groupId, @Nullable TaskResource taskResource, DataSchema dataSchema, ParallelIndexTuningConfig tuningConfig, @Nullable Map<String, Object> context, String supervisorTaskId) {
        super(id, groupId, taskResource, dataSchema.getDataSource(), context, AbstractTask.IngestionMode.NONE, supervisorTaskId);
        Preconditions.checkArgument((boolean)tuningConfig.isForceGuaranteedRollup(), (Object)"forceGuaranteedRollup must be set");
        PerfectRollupWorkerTask.checkPartitionsSpec(tuningConfig.getGivenOrDefaultPartitionsSpec());
        this.granularitySpec = dataSchema.getGranularitySpec();
        this.dataSchema = dataSchema;
        this.tuningConfig = tuningConfig;
    }

    private static void checkPartitionsSpec(PartitionsSpec partitionsSpec) {
        if (!partitionsSpec.isForceGuaranteedRollupCompatible()) {
            String incompatibiltyMsg = partitionsSpec.getForceGuaranteedRollupIncompatiblityReason();
            String msg = "forceGuaranteedRollup is incompatible with partitionsSpec: " + incompatibiltyMsg;
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public final boolean requireLockExistingSegments() {
        return true;
    }

    @Override
    public final List<DataSegment> findSegmentsToLock(TaskActionClient taskActionClient, List<Interval> intervals) {
        throw new UnsupportedOperationException("This task locks by timeChunk instead of segment");
    }

    @Override
    public final boolean isPerfectRollup() {
        return true;
    }

    @Override
    @Nullable
    public final Granularity getSegmentGranularity() {
        if (this.granularitySpec instanceof ArbitraryGranularitySpec) {
            return null;
        }
        return this.granularitySpec.getSegmentGranularity();
    }

    DataSchema getDataSchema() {
        return this.dataSchema;
    }

    ParallelIndexTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }
}

