/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.BlockChecksumType;

@InterfaceAudience.Private
public class BlockChecksumOptions {
    private final BlockChecksumType blockChecksumType;
    private final long stripeLength;

    public BlockChecksumOptions(BlockChecksumType blockChecksumType, long stripeLength) {
        this.blockChecksumType = blockChecksumType;
        this.stripeLength = stripeLength;
    }

    public BlockChecksumOptions(BlockChecksumType blockChecksumType) {
        this(blockChecksumType, 0L);
    }

    public BlockChecksumType getBlockChecksumType() {
        return this.blockChecksumType;
    }

    public long getStripeLength() {
        return this.stripeLength;
    }

    public String toString() {
        return String.format("blockChecksumType=%s, stripedLength=%d", new Object[]{this.blockChecksumType, this.stripeLength});
    }
}

