/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.storage.s3.S3Utils;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;

public class ObjectSummaryIterator
implements Iterator<S3ObjectSummary> {
    private final ServerSideEncryptingAmazonS3 s3Client;
    private final Iterator<URI> prefixesIterator;
    private final int maxListingLength;
    private ListObjectsV2Request request;
    private ListObjectsV2Result result;
    private Iterator<S3ObjectSummary> objectSummaryIterator;
    private S3ObjectSummary currentObjectSummary;
    private int maxRetries;

    ObjectSummaryIterator(ServerSideEncryptingAmazonS3 s3Client, Iterable<URI> prefixes, int maxListingLength) {
        this.s3Client = s3Client;
        this.prefixesIterator = prefixes.iterator();
        this.maxListingLength = maxListingLength;
        this.maxRetries = 10;
        this.constructorPostProcessing();
    }

    @VisibleForTesting
    ObjectSummaryIterator(ServerSideEncryptingAmazonS3 s3Client, Iterable<URI> prefixes, int maxListingLength, int maxRetries) {
        this.s3Client = s3Client;
        this.prefixesIterator = prefixes.iterator();
        this.maxListingLength = maxListingLength;
        this.maxRetries = maxRetries;
        this.constructorPostProcessing();
    }

    private void constructorPostProcessing() {
        this.prepareNextRequest();
        this.fetchNextBatch();
        this.advanceObjectSummary();
    }

    @Override
    public boolean hasNext() {
        return this.currentObjectSummary != null;
    }

    @Override
    public S3ObjectSummary next() {
        if (this.currentObjectSummary == null) {
            throw new NoSuchElementException();
        }
        S3ObjectSummary retVal = this.currentObjectSummary;
        this.advanceObjectSummary();
        return retVal;
    }

    private void prepareNextRequest() {
        URI currentUri = this.prefixesIterator.next();
        String currentBucket = currentUri.getAuthority();
        String currentPrefix = S3Utils.extractS3Key(currentUri);
        this.request = new ListObjectsV2Request().withBucketName(currentBucket).withPrefix(currentPrefix).withMaxKeys(Integer.valueOf(this.maxListingLength));
    }

    private void fetchNextBatch() {
        try {
            this.result = (ListObjectsV2Result)S3Utils.retryS3Operation(() -> this.s3Client.listObjectsV2(this.request), this.maxRetries);
            this.request.setContinuationToken(this.result.getNextContinuationToken());
            this.objectSummaryIterator = this.result.getObjectSummaries().iterator();
        }
        catch (AmazonS3Exception e) {
            throw new RE((Throwable)e, "Failed to get object summaries from S3 bucket[%s], prefix[%s]; S3 error: %s", new Object[]{this.request.getBucketName(), this.request.getPrefix(), e.getMessage()});
        }
        catch (Exception e) {
            throw new RE((Throwable)e, "Failed to get object summaries from S3 bucket[%s], prefix[%s]", new Object[]{this.request.getBucketName(), this.request.getPrefix()});
        }
    }

    private void advanceObjectSummary() {
        while (this.objectSummaryIterator.hasNext() || this.result.isTruncated() || this.prefixesIterator.hasNext()) {
            while (this.objectSummaryIterator.hasNext()) {
                this.currentObjectSummary = this.objectSummaryIterator.next();
                if (ObjectSummaryIterator.isDirectoryPlaceholder(this.currentObjectSummary) || this.currentObjectSummary.getSize() <= 0L) continue;
                return;
            }
            if (this.result.isTruncated()) {
                this.fetchNextBatch();
                continue;
            }
            if (!this.prefixesIterator.hasNext()) continue;
            this.prepareNextRequest();
            this.fetchNextBatch();
        }
        this.currentObjectSummary = null;
    }

    private static boolean isDirectoryPlaceholder(S3ObjectSummary objectSummary) {
        if (objectSummary.getKey().endsWith("/") && objectSummary.getSize() == 0L) {
            return true;
        }
        if ("d66759af42f282e1ba19144df2d405d0".equals(objectSummary.getETag())) {
            return true;
        }
        return objectSummary.getKey().endsWith("_$folder$") && objectSummary.getSize() == 0L;
    }
}

