/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.schemarepo.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRepository
implements Repository {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean closed;

    public void isValid() {
        if (this.closed) {
            throw new IllegalStateException("Repository is closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.logger.info("Closing {}", (Object)this);
    }

    protected Map<String, String> exposeConfiguration() {
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(super.toString());
        Map<String, String> properties = this.exposeConfiguration();
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                builder.append("\n\t").append(entry.getKey()).append("\t: ").append(entry.getValue());
            }
        }
        return builder.toString();
    }
}

