/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.IntegrationError;
import com.amazonaws.services.rds.model.ModifyIntegrationResult;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.services.rds.model.transform.IntegrationErrorStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

public class ModifyIntegrationResultStaxUnmarshaller
implements Unmarshaller<ModifyIntegrationResult, StaxUnmarshallerContext> {
    private static ModifyIntegrationResultStaxUnmarshaller instance;

    public ModifyIntegrationResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        ModifyIntegrationResult modifyIntegrationResult = new ModifyIntegrationResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return modifyIntegrationResult;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SourceArn", targetDepth)) {
                    modifyIntegrationResult.setSourceArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TargetArn", targetDepth)) {
                    modifyIntegrationResult.setTargetArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IntegrationName", targetDepth)) {
                    modifyIntegrationResult.setIntegrationName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IntegrationArn", targetDepth)) {
                    modifyIntegrationResult.setIntegrationArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KMSKeyId", targetDepth)) {
                    modifyIntegrationResult.setKMSKeyId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AdditionalEncryptionContext/entry", targetDepth)) {
                    Map.Entry<String, String> entry = AdditionalEncryptionContextMapEntryUnmarshaller.getInstance().unmarshall(context);
                    modifyIntegrationResult.addAdditionalEncryptionContextEntry(entry.getKey(), entry.getValue());
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    modifyIntegrationResult.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    modifyIntegrationResult.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("Tags/Tag", targetDepth)) {
                    modifyIntegrationResult.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreateTime", targetDepth)) {
                    modifyIntegrationResult.setCreateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("Errors", targetDepth)) {
                    modifyIntegrationResult.withErrors(new ArrayList<IntegrationError>());
                    continue;
                }
                if (context.testExpression("Errors/IntegrationError", targetDepth)) {
                    modifyIntegrationResult.withErrors(IntegrationErrorStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DataFilter", targetDepth)) {
                    modifyIntegrationResult.setDataFilter(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Description", targetDepth)) continue;
                modifyIntegrationResult.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return modifyIntegrationResult;
    }

    public static ModifyIntegrationResultStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ModifyIntegrationResultStaxUnmarshaller();
        }
        return instance;
    }

    private static class AdditionalEncryptionContextMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static AdditionalEncryptionContextMapEntryUnmarshaller instance;

        private AdditionalEncryptionContextMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static AdditionalEncryptionContextMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new AdditionalEncryptionContextMapEntryUnmarshaller();
            }
            return instance;
        }
    }
}

