/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common.httpclient.okhttp;

import io.fabric8.kubernetes.client.okhttp.OkHttpClientFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.k8s.overlord.common.httpclient.DruidKubernetesHttpClientFactory;
import org.apache.druid.k8s.overlord.common.httpclient.okhttp.DruidKubernetesOkHttpHttpClientConfig;

public class DruidKubernetesOkHttpHttpClientFactory
extends OkHttpClientFactory
implements DruidKubernetesHttpClientFactory {
    public static final String TYPE_NAME = "okhttp";
    private final DruidKubernetesOkHttpHttpClientConfig config;

    public DruidKubernetesOkHttpHttpClientFactory(DruidKubernetesOkHttpHttpClientConfig config) {
        this.config = config;
    }

    protected void additionalConfig(OkHttpClient.Builder builder) {
        if (this.config.isUseCustomDispatcherExecutor()) {
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(this.config.getCoreWorkerThreads(), this.config.getMaxWorkerThreads(), this.config.getWorkerThreadKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Execs.makeThreadFactory((String)"OkHttpHttpClient-%d"));
            Dispatcher dispatcher = new Dispatcher((ExecutorService)executorService);
            dispatcher.setMaxRequests(this.config.getMaxWorkerThreads());
            dispatcher.setMaxRequestsPerHost(this.config.getMaxWorkerThreads());
            builder.dispatcher(dispatcher);
        }
    }
}

