/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1alpha1MatchResources;
import io.kubernetes.client.openapi.models.V1alpha1MatchResourcesBuilder;
import io.kubernetes.client.openapi.models.V1alpha1MatchResourcesFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha1ParamRef;
import io.kubernetes.client.openapi.models.V1alpha1ParamRefBuilder;
import io.kubernetes.client.openapi.models.V1alpha1ParamRefFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha1ValidatingAdmissionPolicyBindingSpec;
import io.kubernetes.client.openapi.models.V1alpha1ValidatingAdmissionPolicyBindingSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha1ValidatingAdmissionPolicyBindingSpecFluentImpl<A extends V1alpha1ValidatingAdmissionPolicyBindingSpecFluent<A>>
extends BaseFluent<A>
implements V1alpha1ValidatingAdmissionPolicyBindingSpecFluent<A> {
    private V1alpha1MatchResourcesBuilder matchResources;
    private V1alpha1ParamRefBuilder paramRef;
    private String policyName;
    private List<String> validationActions;

    public V1alpha1ValidatingAdmissionPolicyBindingSpecFluentImpl() {
    }

    public V1alpha1ValidatingAdmissionPolicyBindingSpecFluentImpl(V1alpha1ValidatingAdmissionPolicyBindingSpec instance) {
        if (instance != null) {
            this.withMatchResources(instance.getMatchResources());
            this.withParamRef(instance.getParamRef());
            this.withPolicyName(instance.getPolicyName());
            this.withValidationActions(instance.getValidationActions());
        }
    }

    @Override
    @Deprecated
    public V1alpha1MatchResources getMatchResources() {
        return this.matchResources != null ? this.matchResources.build() : null;
    }

    @Override
    public V1alpha1MatchResources buildMatchResources() {
        return this.matchResources != null ? this.matchResources.build() : null;
    }

    @Override
    public A withMatchResources(V1alpha1MatchResources matchResources) {
        this._visitables.get("matchResources").remove(this.matchResources);
        if (matchResources != null) {
            this.matchResources = new V1alpha1MatchResourcesBuilder(matchResources);
            this._visitables.get("matchResources").add(this.matchResources);
        } else {
            this.matchResources = null;
            this._visitables.get("matchResources").remove(this.matchResources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatchResources() {
        return this.matchResources != null;
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.MatchResourcesNested<A> withNewMatchResources() {
        return new MatchResourcesNestedImpl();
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.MatchResourcesNested<A> withNewMatchResourcesLike(V1alpha1MatchResources item) {
        return new MatchResourcesNestedImpl(item);
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.MatchResourcesNested<A> editMatchResources() {
        return this.withNewMatchResourcesLike(this.getMatchResources());
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.MatchResourcesNested<A> editOrNewMatchResources() {
        return this.withNewMatchResourcesLike(this.getMatchResources() != null ? this.getMatchResources() : new V1alpha1MatchResourcesBuilder().build());
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.MatchResourcesNested<A> editOrNewMatchResourcesLike(V1alpha1MatchResources item) {
        return this.withNewMatchResourcesLike(this.getMatchResources() != null ? this.getMatchResources() : item);
    }

    @Override
    @Deprecated
    public V1alpha1ParamRef getParamRef() {
        return this.paramRef != null ? this.paramRef.build() : null;
    }

    @Override
    public V1alpha1ParamRef buildParamRef() {
        return this.paramRef != null ? this.paramRef.build() : null;
    }

    @Override
    public A withParamRef(V1alpha1ParamRef paramRef) {
        this._visitables.get("paramRef").remove(this.paramRef);
        if (paramRef != null) {
            this.paramRef = new V1alpha1ParamRefBuilder(paramRef);
            this._visitables.get("paramRef").add(this.paramRef);
        } else {
            this.paramRef = null;
            this._visitables.get("paramRef").remove(this.paramRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasParamRef() {
        return this.paramRef != null;
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.ParamRefNested<A> withNewParamRef() {
        return new ParamRefNestedImpl();
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.ParamRefNested<A> withNewParamRefLike(V1alpha1ParamRef item) {
        return new ParamRefNestedImpl(item);
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.ParamRefNested<A> editParamRef() {
        return this.withNewParamRefLike(this.getParamRef());
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.ParamRefNested<A> editOrNewParamRef() {
        return this.withNewParamRefLike(this.getParamRef() != null ? this.getParamRef() : new V1alpha1ParamRefBuilder().build());
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.ParamRefNested<A> editOrNewParamRefLike(V1alpha1ParamRef item) {
        return this.withNewParamRefLike(this.getParamRef() != null ? this.getParamRef() : item);
    }

    @Override
    public String getPolicyName() {
        return this.policyName;
    }

    @Override
    public A withPolicyName(String policyName) {
        this.policyName = policyName;
        return (A)this;
    }

    @Override
    public Boolean hasPolicyName() {
        return this.policyName != null;
    }

    @Override
    public A addToValidationActions(int index, String item) {
        if (this.validationActions == null) {
            this.validationActions = new ArrayList<String>();
        }
        this.validationActions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToValidationActions(int index, String item) {
        if (this.validationActions == null) {
            this.validationActions = new ArrayList<String>();
        }
        this.validationActions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToValidationActions(String ... items) {
        if (this.validationActions == null) {
            this.validationActions = new ArrayList<String>();
        }
        for (String item : items) {
            this.validationActions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToValidationActions(Collection<String> items) {
        if (this.validationActions == null) {
            this.validationActions = new ArrayList<String>();
        }
        for (String item : items) {
            this.validationActions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromValidationActions(String ... items) {
        for (String item : items) {
            if (this.validationActions == null) continue;
            this.validationActions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromValidationActions(Collection<String> items) {
        for (String item : items) {
            if (this.validationActions == null) continue;
            this.validationActions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getValidationActions() {
        return this.validationActions;
    }

    @Override
    public String getValidationAction(int index) {
        return this.validationActions.get(index);
    }

    @Override
    public String getFirstValidationAction() {
        return this.validationActions.get(0);
    }

    @Override
    public String getLastValidationAction() {
        return this.validationActions.get(this.validationActions.size() - 1);
    }

    @Override
    public String getMatchingValidationAction(Predicate<String> predicate) {
        for (String item : this.validationActions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingValidationAction(Predicate<String> predicate) {
        for (String item : this.validationActions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withValidationActions(List<String> validationActions) {
        if (validationActions != null) {
            this.validationActions = new ArrayList<String>();
            for (String item : validationActions) {
                this.addToValidationActions(item);
            }
        } else {
            this.validationActions = null;
        }
        return (A)this;
    }

    @Override
    public A withValidationActions(String ... validationActions) {
        if (this.validationActions != null) {
            this.validationActions.clear();
            this._visitables.remove("validationActions");
        }
        if (validationActions != null) {
            for (String item : validationActions) {
                this.addToValidationActions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasValidationActions() {
        return this.validationActions != null && !this.validationActions.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha1ValidatingAdmissionPolicyBindingSpecFluentImpl that = (V1alpha1ValidatingAdmissionPolicyBindingSpecFluentImpl)o;
        if (!Objects.equals(this.matchResources, that.matchResources)) {
            return false;
        }
        if (!Objects.equals(this.paramRef, that.paramRef)) {
            return false;
        }
        if (!Objects.equals(this.policyName, that.policyName)) {
            return false;
        }
        return Objects.equals(this.validationActions, that.validationActions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.matchResources, this.paramRef, this.policyName, this.validationActions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.matchResources != null) {
            sb.append("matchResources:");
            sb.append(this.matchResources + ",");
        }
        if (this.paramRef != null) {
            sb.append("paramRef:");
            sb.append(this.paramRef + ",");
        }
        if (this.policyName != null) {
            sb.append("policyName:");
            sb.append(this.policyName + ",");
        }
        if (this.validationActions != null && !this.validationActions.isEmpty()) {
            sb.append("validationActions:");
            sb.append(this.validationActions);
        }
        sb.append("}");
        return sb.toString();
    }

    class MatchResourcesNestedImpl<N>
    extends V1alpha1MatchResourcesFluentImpl<V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.MatchResourcesNested<N>>
    implements V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.MatchResourcesNested<N>,
    Nested<N> {
        V1alpha1MatchResourcesBuilder builder;

        MatchResourcesNestedImpl(V1alpha1MatchResources item) {
            this.builder = new V1alpha1MatchResourcesBuilder(this, item);
        }

        MatchResourcesNestedImpl() {
            this.builder = new V1alpha1MatchResourcesBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1ValidatingAdmissionPolicyBindingSpecFluentImpl.this.withMatchResources(this.builder.build());
        }

        @Override
        public N endMatchResources() {
            return this.and();
        }
    }

    class ParamRefNestedImpl<N>
    extends V1alpha1ParamRefFluentImpl<V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.ParamRefNested<N>>
    implements V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.ParamRefNested<N>,
    Nested<N> {
        V1alpha1ParamRefBuilder builder;

        ParamRefNestedImpl(V1alpha1ParamRef item) {
            this.builder = new V1alpha1ParamRefBuilder(this, item);
        }

        ParamRefNestedImpl() {
            this.builder = new V1alpha1ParamRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1ValidatingAdmissionPolicyBindingSpecFluentImpl.this.withParamRef(this.builder.build());
        }

        @Override
        public N endParamRef() {
            return this.and();
        }
    }
}

