/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package extension

import (
	"github.com/apache/dubbo-go/config/interfaces"
)

var (
	processors = make(map[string]interfaces.ConfigPostProcessor)
)

// SetConfigPostProcessor registers a ConfigPostProcessor with the given name.
func SetConfigPostProcessor(name string, processor interfaces.ConfigPostProcessor) {
	processors[name] = processor
}

// GetConfigPostProcessor finds a ConfigPostProcessor by name.
func GetConfigPostProcessor(name string) interfaces.ConfigPostProcessor {
	return processors[name]
}

// RemoveConfigPostProcessor remove process from processors.
func RemoveConfigPostProcessor(name string) {
	delete(processors, name)
}

// GetConfigPostProcessors returns all registered instances of ConfigPostProcessor.
func GetConfigPostProcessors() []interfaces.ConfigPostProcessor {
	ret := make([]interfaces.ConfigPostProcessor, 0, len(processors))
	for _, v := range processors {
		ret = append(ret, v)
	}
	return ret
}
