/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.helpdesk.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.helpdesk.v1.model.AgentEmailAgentResp;
import com.lark.oapi.service.helpdesk.v1.model.AnswerUserQueryTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.AnswerUserQueryTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.CancelApproveNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.CancelApproveNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.CancelSendNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.CancelSendNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateAgentScheduleReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateAgentScheduleResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateAgentSkillReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateAgentSkillResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateBotMessageReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateBotMessageResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateCategoryReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateCategoryResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateFaqReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateFaqResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateTicketCustomizedFieldReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateTicketCustomizedFieldResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateTicketMessageReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateTicketMessageResp;
import com.lark.oapi.service.helpdesk.v1.model.CustomizedFieldsTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.CustomizedFieldsTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.DeleteAgentSchedulesReq;
import com.lark.oapi.service.helpdesk.v1.model.DeleteAgentSchedulesResp;
import com.lark.oapi.service.helpdesk.v1.model.DeleteAgentSkillReq;
import com.lark.oapi.service.helpdesk.v1.model.DeleteAgentSkillResp;
import com.lark.oapi.service.helpdesk.v1.model.DeleteCategoryReq;
import com.lark.oapi.service.helpdesk.v1.model.DeleteCategoryResp;
import com.lark.oapi.service.helpdesk.v1.model.DeleteFaqReq;
import com.lark.oapi.service.helpdesk.v1.model.DeleteFaqResp;
import com.lark.oapi.service.helpdesk.v1.model.DeleteTicketCustomizedFieldReq;
import com.lark.oapi.service.helpdesk.v1.model.DeleteTicketCustomizedFieldResp;
import com.lark.oapi.service.helpdesk.v1.model.ExecuteSendNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.ExecuteSendNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.FaqImageFaqReq;
import com.lark.oapi.service.helpdesk.v1.model.FaqImageFaqResp;
import com.lark.oapi.service.helpdesk.v1.model.GetAgentSchedulesReq;
import com.lark.oapi.service.helpdesk.v1.model.GetAgentSchedulesResp;
import com.lark.oapi.service.helpdesk.v1.model.GetAgentSkillReq;
import com.lark.oapi.service.helpdesk.v1.model.GetAgentSkillResp;
import com.lark.oapi.service.helpdesk.v1.model.GetCategoryReq;
import com.lark.oapi.service.helpdesk.v1.model.GetCategoryResp;
import com.lark.oapi.service.helpdesk.v1.model.GetFaqReq;
import com.lark.oapi.service.helpdesk.v1.model.GetFaqResp;
import com.lark.oapi.service.helpdesk.v1.model.GetNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.GetNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.GetTicketCustomizedFieldReq;
import com.lark.oapi.service.helpdesk.v1.model.GetTicketCustomizedFieldResp;
import com.lark.oapi.service.helpdesk.v1.model.GetTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.GetTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.ListAgentScheduleReq;
import com.lark.oapi.service.helpdesk.v1.model.ListAgentScheduleResp;
import com.lark.oapi.service.helpdesk.v1.model.ListAgentSkillResp;
import com.lark.oapi.service.helpdesk.v1.model.ListAgentSkillRuleResp;
import com.lark.oapi.service.helpdesk.v1.model.ListCategoryReq;
import com.lark.oapi.service.helpdesk.v1.model.ListCategoryResp;
import com.lark.oapi.service.helpdesk.v1.model.ListFaqReq;
import com.lark.oapi.service.helpdesk.v1.model.ListFaqResp;
import com.lark.oapi.service.helpdesk.v1.model.ListTicketCustomizedFieldReq;
import com.lark.oapi.service.helpdesk.v1.model.ListTicketCustomizedFieldResp;
import com.lark.oapi.service.helpdesk.v1.model.ListTicketMessageReq;
import com.lark.oapi.service.helpdesk.v1.model.ListTicketMessageResp;
import com.lark.oapi.service.helpdesk.v1.model.ListTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.ListTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.P2NotificationApproveV1;
import com.lark.oapi.service.helpdesk.v1.model.P2TicketCreatedV1;
import com.lark.oapi.service.helpdesk.v1.model.P2TicketMessageCreatedV1;
import com.lark.oapi.service.helpdesk.v1.model.P2TicketUpdatedV1;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentResp;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentSchedulesReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentSchedulesResp;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentSkillReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentSkillResp;
import com.lark.oapi.service.helpdesk.v1.model.PatchCategoryReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchCategoryResp;
import com.lark.oapi.service.helpdesk.v1.model.PatchFaqReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchFaqResp;
import com.lark.oapi.service.helpdesk.v1.model.PatchNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.PatchTicketCustomizedFieldReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchTicketCustomizedFieldResp;
import com.lark.oapi.service.helpdesk.v1.model.PreviewNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.PreviewNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.SearchFaqReq;
import com.lark.oapi.service.helpdesk.v1.model.SearchFaqResp;
import com.lark.oapi.service.helpdesk.v1.model.StartServiceTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.StartServiceTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.SubmitApproveNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.SubmitApproveNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.SubscribeEventReq;
import com.lark.oapi.service.helpdesk.v1.model.SubscribeEventResp;
import com.lark.oapi.service.helpdesk.v1.model.TicketImageTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.TicketImageTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.UnsubscribeEventReq;
import com.lark.oapi.service.helpdesk.v1.model.UnsubscribeEventResp;
import com.lark.oapi.service.helpdesk.v1.model.UpdateTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.UpdateTicketResp;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpdeskService {
    private static final Logger log = LoggerFactory.getLogger(HelpdeskService.class);
    private final Agent agent;
    private final AgentSchedules agentSchedules;
    private final AgentSchedule agentSchedule;
    private final AgentSkill agentSkill;
    private final AgentSkillRule agentSkillRule;
    private final BotMessage botMessage;
    private final Category category;
    private final Event event;
    private final Faq faq;
    private final Notification notification;
    private final Ticket ticket;
    private final TicketMessage ticketMessage;
    private final TicketCustomizedField ticketCustomizedField;

    public HelpdeskService(Config config) {
        this.agent = new Agent(config);
        this.agentSchedules = new AgentSchedules(config);
        this.agentSchedule = new AgentSchedule(config);
        this.agentSkill = new AgentSkill(config);
        this.agentSkillRule = new AgentSkillRule(config);
        this.botMessage = new BotMessage(config);
        this.category = new Category(config);
        this.event = new Event(config);
        this.faq = new Faq(config);
        this.notification = new Notification(config);
        this.ticket = new Ticket(config);
        this.ticketMessage = new TicketMessage(config);
        this.ticketCustomizedField = new TicketCustomizedField(config);
    }

    public Agent agent() {
        return this.agent;
    }

    public AgentSchedules agentSchedules() {
        return this.agentSchedules;
    }

    public AgentSchedule agentSchedule() {
        return this.agentSchedule;
    }

    public AgentSkill agentSkill() {
        return this.agentSkill;
    }

    public AgentSkillRule agentSkillRule() {
        return this.agentSkillRule;
    }

    public BotMessage botMessage() {
        return this.botMessage;
    }

    public Category category() {
        return this.category;
    }

    public Event event() {
        return this.event;
    }

    public Faq faq() {
        return this.faq;
    }

    public Notification notification() {
        return this.notification;
    }

    public Ticket ticket() {
        return this.ticket;
    }

    public TicketMessage ticketMessage() {
        return this.ticketMessage;
    }

    public TicketCustomizedField ticketCustomizedField() {
        return this.ticketCustomizedField;
    }

    public static abstract class P2TicketMessageCreatedV1Handler
    implements IEventHandler<P2TicketMessageCreatedV1> {
        @Override
        public P2TicketMessageCreatedV1 getEvent() {
            return new P2TicketMessageCreatedV1();
        }
    }

    public static abstract class P2TicketUpdatedV1Handler
    implements IEventHandler<P2TicketUpdatedV1> {
        @Override
        public P2TicketUpdatedV1 getEvent() {
            return new P2TicketUpdatedV1();
        }
    }

    public static abstract class P2TicketCreatedV1Handler
    implements IEventHandler<P2TicketCreatedV1> {
        @Override
        public P2TicketCreatedV1 getEvent() {
            return new P2TicketCreatedV1();
        }
    }

    public static abstract class P2NotificationApproveV1Handler
    implements IEventHandler<P2NotificationApproveV1> {
        @Override
        public P2NotificationApproveV1 getEvent() {
            return new P2NotificationApproveV1();
        }
    }

    public static class TicketCustomizedField {
        private final Config config;

        public TicketCustomizedField(Config config) {
            this.config = config;
        }

        public CreateTicketCustomizedFieldResp create(CreateTicketCustomizedFieldReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateTicketCustomizedFieldResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/ticket_customized_fields", Sets.newHashSet(AccessTokenType.User), req), CreateTicketCustomizedFieldResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/ticket_customized_fields", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateTicketCustomizedFieldResp create(CreateTicketCustomizedFieldReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/ticket_customized_fields", Sets.newHashSet(AccessTokenType.User), req);
            CreateTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateTicketCustomizedFieldResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/ticket_customized_fields", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteTicketCustomizedFieldResp delete(DeleteTicketCustomizedFieldReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            DeleteTicketCustomizedFieldResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id", Sets.newHashSet(AccessTokenType.User), req), DeleteTicketCustomizedFieldResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteTicketCustomizedFieldResp delete(DeleteTicketCustomizedFieldReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id", Sets.newHashSet(AccessTokenType.User), req);
            DeleteTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteTicketCustomizedFieldResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetTicketCustomizedFieldResp get(GetTicketCustomizedFieldReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetTicketCustomizedFieldResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetTicketCustomizedFieldResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetTicketCustomizedFieldResp get(GetTicketCustomizedFieldReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTicketCustomizedFieldResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTicketCustomizedFieldResp list(ListTicketCustomizedFieldReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListTicketCustomizedFieldResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/ticket_customized_fields", Sets.newHashSet(AccessTokenType.Tenant), req), ListTicketCustomizedFieldResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/ticket_customized_fields", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTicketCustomizedFieldResp list(ListTicketCustomizedFieldReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/ticket_customized_fields", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTicketCustomizedFieldResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/ticket_customized_fields", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchTicketCustomizedFieldResp patch(PatchTicketCustomizedFieldReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchTicketCustomizedFieldResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id", Sets.newHashSet(AccessTokenType.User), req), PatchTicketCustomizedFieldResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchTicketCustomizedFieldResp patch(PatchTicketCustomizedFieldReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id", Sets.newHashSet(AccessTokenType.User), req);
            PatchTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchTicketCustomizedFieldResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class TicketMessage {
        private final Config config;

        public TicketMessage(Config config) {
            this.config = config;
        }

        public CreateTicketMessageResp create(CreateTicketMessageReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateTicketMessageResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/tickets/:ticket_id/messages", Sets.newHashSet(AccessTokenType.Tenant), req), CreateTicketMessageResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id/messages", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateTicketMessageResp create(CreateTicketMessageReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/tickets/:ticket_id/messages", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateTicketMessageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateTicketMessageResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id/messages", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTicketMessageResp list(ListTicketMessageReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListTicketMessageResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/tickets/:ticket_id/messages", Sets.newHashSet(AccessTokenType.Tenant), req), ListTicketMessageResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id/messages", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTicketMessageResp list(ListTicketMessageReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/tickets/:ticket_id/messages", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListTicketMessageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTicketMessageResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id/messages", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Ticket {
        private final Config config;

        public Ticket(Config config) {
            this.config = config;
        }

        public AnswerUserQueryTicketResp answerUserQuery(AnswerUserQueryTicketReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            AnswerUserQueryTicketResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/tickets/:ticket_id/answer_user_query", Sets.newHashSet(AccessTokenType.Tenant), req), AnswerUserQueryTicketResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id/answer_user_query", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public AnswerUserQueryTicketResp answerUserQuery(AnswerUserQueryTicketReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/tickets/:ticket_id/answer_user_query", Sets.newHashSet(AccessTokenType.Tenant), req);
            AnswerUserQueryTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, AnswerUserQueryTicketResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id/answer_user_query", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CustomizedFieldsTicketResp customizedFields(CustomizedFieldsTicketReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CustomizedFieldsTicketResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/customized_fields", Sets.newHashSet(AccessTokenType.Tenant), req), CustomizedFieldsTicketResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/customized_fields", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CustomizedFieldsTicketResp customizedFields(CustomizedFieldsTicketReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/customized_fields", Sets.newHashSet(AccessTokenType.Tenant), req);
            CustomizedFieldsTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CustomizedFieldsTicketResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/customized_fields", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetTicketResp get(GetTicketReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetTicketResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/tickets/:ticket_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetTicketResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetTicketResp get(GetTicketReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/tickets/:ticket_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTicketResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTicketResp list(ListTicketReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListTicketResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/tickets", Sets.newHashSet(AccessTokenType.Tenant), req), ListTicketResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTicketResp list(ListTicketReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/tickets", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTicketResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public StartServiceTicketResp startService(StartServiceTicketReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            StartServiceTicketResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/start_service", Sets.newHashSet(AccessTokenType.Tenant), req), StartServiceTicketResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/start_service", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public StartServiceTicketResp startService(StartServiceTicketReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/start_service", Sets.newHashSet(AccessTokenType.Tenant), req);
            StartServiceTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, StartServiceTicketResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/start_service", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public TicketImageTicketResp ticketImage(TicketImageTicketReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/ticket_images", Sets.newHashSet(AccessTokenType.Tenant), req);
            if (httpResponse.getStatusCode() == 200) {
                TicketImageTicketResp resp = new TicketImageTicketResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setData(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            TicketImageTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, TicketImageTicketResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/ticket_images", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public TicketImageTicketResp ticketImage(TicketImageTicketReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/ticket_images", Sets.newHashSet(AccessTokenType.Tenant), req);
            if (httpResponse.getStatusCode() == 200) {
                TicketImageTicketResp resp = new TicketImageTicketResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setData(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            TicketImageTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, TicketImageTicketResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/ticket_images", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateTicketResp update(UpdateTicketReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            UpdateTicketResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/helpdesk/v1/tickets/:ticket_id", Sets.newHashSet(AccessTokenType.User), req), UpdateTicketResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateTicketResp update(UpdateTicketReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/helpdesk/v1/tickets/:ticket_id", Sets.newHashSet(AccessTokenType.User), req);
            UpdateTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateTicketResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Notification {
        private final Config config;

        public Notification(Config config) {
            this.config = config;
        }

        public CancelApproveNotificationResp cancelApprove(CancelApproveNotificationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CancelApproveNotificationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/notifications/:notification_id/cancel_approve", Sets.newHashSet(AccessTokenType.User), req), CancelApproveNotificationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications/:notification_id/cancel_approve", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CancelApproveNotificationResp cancelApprove(CancelApproveNotificationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/notifications/:notification_id/cancel_approve", Sets.newHashSet(AccessTokenType.User), req);
            CancelApproveNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CancelApproveNotificationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications/:notification_id/cancel_approve", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CancelSendNotificationResp cancelSend(CancelSendNotificationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CancelSendNotificationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/notifications/:notification_id/cancel_send", Sets.newHashSet(AccessTokenType.User), req), CancelSendNotificationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications/:notification_id/cancel_send", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CancelSendNotificationResp cancelSend(CancelSendNotificationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/notifications/:notification_id/cancel_send", Sets.newHashSet(AccessTokenType.User), req);
            CancelSendNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CancelSendNotificationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications/:notification_id/cancel_send", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateNotificationResp create(CreateNotificationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateNotificationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/notifications", Sets.newHashSet(AccessTokenType.User), req), CreateNotificationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateNotificationResp create(CreateNotificationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/notifications", Sets.newHashSet(AccessTokenType.User), req);
            CreateNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateNotificationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ExecuteSendNotificationResp executeSend(ExecuteSendNotificationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ExecuteSendNotificationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/notifications/:notification_id/execute_send", Sets.newHashSet(AccessTokenType.User), req), ExecuteSendNotificationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications/:notification_id/execute_send", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ExecuteSendNotificationResp executeSend(ExecuteSendNotificationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/notifications/:notification_id/execute_send", Sets.newHashSet(AccessTokenType.User), req);
            ExecuteSendNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ExecuteSendNotificationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications/:notification_id/execute_send", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetNotificationResp get(GetNotificationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetNotificationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/notifications/:notification_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), GetNotificationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications/:notification_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetNotificationResp get(GetNotificationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/notifications/:notification_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetNotificationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications/:notification_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchNotificationResp patch(PatchNotificationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchNotificationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/notifications/:notification_id", Sets.newHashSet(AccessTokenType.User), req), PatchNotificationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications/:notification_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchNotificationResp patch(PatchNotificationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/notifications/:notification_id", Sets.newHashSet(AccessTokenType.User), req);
            PatchNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchNotificationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications/:notification_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PreviewNotificationResp preview(PreviewNotificationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PreviewNotificationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/notifications/:notification_id/preview", Sets.newHashSet(AccessTokenType.User), req), PreviewNotificationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications/:notification_id/preview", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PreviewNotificationResp preview(PreviewNotificationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/notifications/:notification_id/preview", Sets.newHashSet(AccessTokenType.User), req);
            PreviewNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PreviewNotificationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications/:notification_id/preview", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SubmitApproveNotificationResp submitApprove(SubmitApproveNotificationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            SubmitApproveNotificationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/notifications/:notification_id/submit_approve", Sets.newHashSet(AccessTokenType.User), req), SubmitApproveNotificationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications/:notification_id/submit_approve", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SubmitApproveNotificationResp submitApprove(SubmitApproveNotificationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/notifications/:notification_id/submit_approve", Sets.newHashSet(AccessTokenType.User), req);
            SubmitApproveNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SubmitApproveNotificationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/notifications/:notification_id/submit_approve", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Faq {
        private final Config config;

        public Faq(Config config) {
            this.config = config;
        }

        public CreateFaqResp create(CreateFaqReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateFaqResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/faqs", Sets.newHashSet(AccessTokenType.User), req), CreateFaqResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/faqs", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateFaqResp create(CreateFaqReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/faqs", Sets.newHashSet(AccessTokenType.User), req);
            CreateFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateFaqResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/faqs", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteFaqResp delete(DeleteFaqReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            DeleteFaqResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/helpdesk/v1/faqs/:id", Sets.newHashSet(AccessTokenType.User), req), DeleteFaqResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/faqs/:id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteFaqResp delete(DeleteFaqReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/helpdesk/v1/faqs/:id", Sets.newHashSet(AccessTokenType.User), req);
            DeleteFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteFaqResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/faqs/:id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public FaqImageFaqResp faqImage(FaqImageFaqReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/faqs/:id/image/:image_key", Sets.newHashSet(AccessTokenType.Tenant), req);
            if (httpResponse.getStatusCode() == 200) {
                FaqImageFaqResp resp = new FaqImageFaqResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setData(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            FaqImageFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, FaqImageFaqResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/faqs/:id/image/:image_key", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public FaqImageFaqResp faqImage(FaqImageFaqReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/faqs/:id/image/:image_key", Sets.newHashSet(AccessTokenType.Tenant), req);
            if (httpResponse.getStatusCode() == 200) {
                FaqImageFaqResp resp = new FaqImageFaqResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setData(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            FaqImageFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, FaqImageFaqResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/faqs/:id/image/:image_key", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetFaqResp get(GetFaqReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetFaqResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/faqs/:id", Sets.newHashSet(AccessTokenType.Tenant), req), GetFaqResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/faqs/:id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetFaqResp get(GetFaqReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/faqs/:id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetFaqResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/faqs/:id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListFaqResp list(ListFaqReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListFaqResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/faqs", Sets.newHashSet(AccessTokenType.Tenant), req), ListFaqResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/faqs", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListFaqResp list(ListFaqReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/faqs", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListFaqResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/faqs", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchFaqResp patch(PatchFaqReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchFaqResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/faqs/:id", Sets.newHashSet(AccessTokenType.User), req), PatchFaqResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/faqs/:id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchFaqResp patch(PatchFaqReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/faqs/:id", Sets.newHashSet(AccessTokenType.User), req);
            PatchFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchFaqResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/faqs/:id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SearchFaqResp search(SearchFaqReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            SearchFaqResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/faqs/search", Sets.newHashSet(AccessTokenType.Tenant), req), SearchFaqResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/faqs/search", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SearchFaqResp search(SearchFaqReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/faqs/search", Sets.newHashSet(AccessTokenType.Tenant), req);
            SearchFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SearchFaqResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/faqs/search", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Event {
        private final Config config;

        public Event(Config config) {
            this.config = config;
        }

        public SubscribeEventResp subscribe(SubscribeEventReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            SubscribeEventResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/events/subscribe", Sets.newHashSet(AccessTokenType.Tenant), req), SubscribeEventResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/events/subscribe", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SubscribeEventResp subscribe(SubscribeEventReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/events/subscribe", Sets.newHashSet(AccessTokenType.Tenant), req);
            SubscribeEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SubscribeEventResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/events/subscribe", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UnsubscribeEventResp unsubscribe(UnsubscribeEventReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            UnsubscribeEventResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/events/unsubscribe", Sets.newHashSet(AccessTokenType.Tenant), req), UnsubscribeEventResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/events/unsubscribe", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UnsubscribeEventResp unsubscribe(UnsubscribeEventReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/events/unsubscribe", Sets.newHashSet(AccessTokenType.Tenant), req);
            UnsubscribeEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UnsubscribeEventResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/events/unsubscribe", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Category {
        private final Config config;

        public Category(Config config) {
            this.config = config;
        }

        public CreateCategoryResp create(CreateCategoryReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateCategoryResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/categories", Sets.newHashSet(AccessTokenType.User), req), CreateCategoryResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/categories", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateCategoryResp create(CreateCategoryReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/categories", Sets.newHashSet(AccessTokenType.User), req);
            CreateCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateCategoryResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/categories", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteCategoryResp delete(DeleteCategoryReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            DeleteCategoryResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/helpdesk/v1/categories/:id", Sets.newHashSet(AccessTokenType.User), req), DeleteCategoryResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/categories/:id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteCategoryResp delete(DeleteCategoryReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/helpdesk/v1/categories/:id", Sets.newHashSet(AccessTokenType.User), req);
            DeleteCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteCategoryResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/categories/:id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetCategoryResp get(GetCategoryReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetCategoryResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/categories/:id", Sets.newHashSet(AccessTokenType.Tenant), req), GetCategoryResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/categories/:id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetCategoryResp get(GetCategoryReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/categories/:id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetCategoryResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/categories/:id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListCategoryResp list(ListCategoryReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListCategoryResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/categories", Sets.newHashSet(AccessTokenType.Tenant), req), ListCategoryResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/categories", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListCategoryResp list(ListCategoryReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/categories", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListCategoryResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/categories", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchCategoryResp patch(PatchCategoryReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchCategoryResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/categories/:id", Sets.newHashSet(AccessTokenType.User), req), PatchCategoryResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/categories/:id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchCategoryResp patch(PatchCategoryReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/categories/:id", Sets.newHashSet(AccessTokenType.User), req);
            PatchCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchCategoryResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/categories/:id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class BotMessage {
        private final Config config;

        public BotMessage(Config config) {
            this.config = config;
        }

        public CreateBotMessageResp create(CreateBotMessageReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateBotMessageResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/message", Sets.newHashSet(AccessTokenType.Tenant), req), CreateBotMessageResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/message", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateBotMessageResp create(CreateBotMessageReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/message", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateBotMessageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateBotMessageResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/message", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class AgentSkillRule {
        private final Config config;

        public AgentSkillRule(Config config) {
            this.config = config;
        }

        public ListAgentSkillRuleResp list(RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListAgentSkillRuleResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agent_skill_rules", Sets.newHashSet(AccessTokenType.Tenant), null), ListAgentSkillRuleResp.class)) == null) {
                log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_skill_rules", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public ListAgentSkillRuleResp list() throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agent_skill_rules", Sets.newHashSet(AccessTokenType.Tenant), null);
            ListAgentSkillRuleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAgentSkillRuleResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_skill_rules", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            return resp;
        }
    }

    public static class AgentSkill {
        private final Config config;

        public AgentSkill(Config config) {
            this.config = config;
        }

        public CreateAgentSkillResp create(CreateAgentSkillReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateAgentSkillResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/agent_skills", Sets.newHashSet(AccessTokenType.User), req), CreateAgentSkillResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_skills", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateAgentSkillResp create(CreateAgentSkillReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/agent_skills", Sets.newHashSet(AccessTokenType.User), req);
            CreateAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateAgentSkillResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_skills", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteAgentSkillResp delete(DeleteAgentSkillReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            DeleteAgentSkillResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id", Sets.newHashSet(AccessTokenType.User), req), DeleteAgentSkillResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteAgentSkillResp delete(DeleteAgentSkillReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id", Sets.newHashSet(AccessTokenType.User), req);
            DeleteAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteAgentSkillResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetAgentSkillResp get(GetAgentSkillReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetAgentSkillResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetAgentSkillResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetAgentSkillResp get(GetAgentSkillReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetAgentSkillResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListAgentSkillResp list(RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListAgentSkillResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agent_skills", Sets.newHashSet(AccessTokenType.Tenant), null), ListAgentSkillResp.class)) == null) {
                log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_skills", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public ListAgentSkillResp list() throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agent_skills", Sets.newHashSet(AccessTokenType.Tenant), null);
            ListAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAgentSkillResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_skills", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public PatchAgentSkillResp patch(PatchAgentSkillReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchAgentSkillResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id", Sets.newHashSet(AccessTokenType.User), req), PatchAgentSkillResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchAgentSkillResp patch(PatchAgentSkillReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id", Sets.newHashSet(AccessTokenType.User), req);
            PatchAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchAgentSkillResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class AgentSchedule {
        private final Config config;

        public AgentSchedule(Config config) {
            this.config = config;
        }

        public CreateAgentScheduleResp create(CreateAgentScheduleReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateAgentScheduleResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/agent_schedules", Sets.newHashSet(AccessTokenType.User), req), CreateAgentScheduleResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateAgentScheduleResp create(CreateAgentScheduleReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/agent_schedules", Sets.newHashSet(AccessTokenType.User), req);
            CreateAgentScheduleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateAgentScheduleResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListAgentScheduleResp list(ListAgentScheduleReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListAgentScheduleResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agent_schedules", Sets.newHashSet(AccessTokenType.Tenant), req), ListAgentScheduleResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListAgentScheduleResp list(ListAgentScheduleReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agent_schedules", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListAgentScheduleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAgentScheduleResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class AgentSchedules {
        private final Config config;

        public AgentSchedules(Config config) {
            this.config = config;
        }

        public DeleteAgentSchedulesResp delete(DeleteAgentSchedulesReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            DeleteAgentSchedulesResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Sets.newHashSet(AccessTokenType.User), req), DeleteAgentSchedulesResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteAgentSchedulesResp delete(DeleteAgentSchedulesReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Sets.newHashSet(AccessTokenType.User), req);
            DeleteAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteAgentSchedulesResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetAgentSchedulesResp get(GetAgentSchedulesReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetAgentSchedulesResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Sets.newHashSet(AccessTokenType.Tenant), req), GetAgentSchedulesResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetAgentSchedulesResp get(GetAgentSchedulesReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetAgentSchedulesResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchAgentSchedulesResp patch(PatchAgentSchedulesReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchAgentSchedulesResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Sets.newHashSet(AccessTokenType.User), req), PatchAgentSchedulesResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchAgentSchedulesResp patch(PatchAgentSchedulesReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Sets.newHashSet(AccessTokenType.User), req);
            PatchAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchAgentSchedulesResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Agent {
        private final Config config;

        public Agent(Config config) {
            this.config = config;
        }

        public AgentEmailAgentResp agentEmail(RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            AgentEmailAgentResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agent_emails", Sets.newHashSet(AccessTokenType.Tenant), null), AgentEmailAgentResp.class)) == null) {
                log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_emails", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public AgentEmailAgentResp agentEmail() throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agent_emails", Sets.newHashSet(AccessTokenType.Tenant), null);
            AgentEmailAgentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, AgentEmailAgentResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_emails", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public PatchAgentResp patch(PatchAgentReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchAgentResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/agents/:agent_id", Sets.newHashSet(AccessTokenType.User), req), PatchAgentResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchAgentResp patch(PatchAgentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/agents/:agent_id", Sets.newHashSet(AccessTokenType.User), req);
            PatchAgentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchAgentResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

