/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server;

import com.navercorp.pinpoint.common.profiler.concurrent.PinpointThreadFactory;
import com.navercorp.pinpoint.common.util.CpuUtils;
import com.navercorp.pinpoint.grpc.ExecutorUtils;
import com.navercorp.pinpoint.grpc.channelz.ChannelzRegistry;
import com.navercorp.pinpoint.grpc.server.ServerChannelType;
import com.navercorp.pinpoint.grpc.server.ServerChannelTypeFactory;
import com.navercorp.pinpoint.grpc.server.ServerOption;
import io.grpc.BindableService;
import io.grpc.InternalWithLogId;
import io.grpc.Server;
import io.grpc.ServerCallExecutorSupplier;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServerTransportFilter;
import io.grpc.internal.ServerImplBuilder;
import io.grpc.netty.NettyServerBuilder;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.Future;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerFactory {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final String name;
    private final String hostname;
    private final int port;
    private final Class<? extends ServerChannel> channelType;
    private final ExecutorService bossExecutor;
    private final EventLoopGroup bossEventLoopGroup;
    private final ExecutorService workerExecutor;
    private final EventLoopGroup workerEventLoopGroup;
    private final Executor serverExecutor;
    private final ServerCallExecutorSupplier callExecutor;
    private final List<Object> bindableServices = new ArrayList<Object>();
    private final List<ServerTransportFilter> serverTransportFilters = new ArrayList<ServerTransportFilter>();
    private final List<ServerInterceptor> serverInterceptors = new ArrayList<ServerInterceptor>();
    private final ServerOption serverOption;
    private final SslContext sslContext;
    private ChannelzRegistry channelzRegistry;

    public ServerFactory(String name, String hostname, int port, Executor serverExecutor, ServerCallExecutorSupplier callExecutor, ServerOption serverOption) {
        this(name, hostname, port, serverExecutor, callExecutor, serverOption, null);
    }

    public ServerFactory(String name, String hostname, int port, Executor serverExecutor, ServerCallExecutorSupplier callExecutor, ServerOption serverOption, SslContext sslContext) {
        this.name = Objects.requireNonNull(name, "name");
        this.hostname = Objects.requireNonNull(hostname, "hostname");
        this.serverOption = Objects.requireNonNull(serverOption, "serverOption");
        this.port = port;
        ServerChannelType serverChannelType = this.getChannelType();
        this.channelType = serverChannelType.getChannelType();
        this.bossExecutor = this.newExecutor(name + "-Channel-Boss");
        this.bossEventLoopGroup = serverChannelType.newEventLoopGroup(1, this.bossExecutor);
        this.workerExecutor = this.newExecutor(name + "-Channel-Worker");
        this.workerEventLoopGroup = serverChannelType.newEventLoopGroup(CpuUtils.cpuCount(), this.workerExecutor);
        this.serverExecutor = Objects.requireNonNull(serverExecutor, "serverExecutor");
        this.callExecutor = callExecutor;
        this.sslContext = sslContext;
    }

    private ServerChannelType getChannelType() {
        ServerChannelTypeFactory factory = new ServerChannelTypeFactory();
        return factory.newChannelType(this.serverOption.getChannelTypeEnum());
    }

    private ExecutorService newExecutor(String name) {
        PinpointThreadFactory threadFactory = new PinpointThreadFactory("Pinpoint-" + name, true);
        return Executors.newCachedThreadPool((ThreadFactory)threadFactory);
    }

    public void setChannelzRegistry(ChannelzRegistry channelzRegistry) {
        this.channelzRegistry = Objects.requireNonNull(channelzRegistry, "channelzRegistry");
    }

    public void addService(BindableService bindableService) {
        Objects.requireNonNull(bindableService, "bindableService");
        this.bindableServices.add(bindableService.bindService());
    }

    public void addService(ServerServiceDefinition serverServiceDefinition) {
        Objects.requireNonNull(serverServiceDefinition, "serverServiceDefinition");
        this.bindableServices.add(serverServiceDefinition);
    }

    public void addTransportFilter(ServerTransportFilter serverTransportFilter) {
        Objects.requireNonNull(serverTransportFilter, "serverTransportFilter");
        this.serverTransportFilters.add(serverTransportFilter);
    }

    public void addInterceptor(ServerInterceptor serverInterceptor) {
        Objects.requireNonNull(serverInterceptor, "serverInterceptor");
        this.serverInterceptors.add(serverInterceptor);
    }

    public Server build() throws SSLException, NoSuchFieldException, IllegalAccessException {
        Server server;
        InetSocketAddress bindAddress = new InetSocketAddress(this.hostname, this.port);
        NettyServerBuilder serverBuilder = NettyServerBuilder.forAddress((SocketAddress)bindAddress);
        this.logger.info("ChannelType:{}", (Object)this.channelType.getSimpleName());
        serverBuilder.channelType(this.channelType);
        serverBuilder.bossEventLoopGroup(this.bossEventLoopGroup);
        serverBuilder.workerEventLoopGroup(this.workerEventLoopGroup);
        ServerImplBuilder serverImplBuilder = ServerFactory.extractServerImplBuilder(serverBuilder);
        this.setupInternal(serverImplBuilder);
        for (Object service : this.bindableServices) {
            if (service instanceof BindableService) {
                this.logger.info("Add BindableService={}, server={}", service, (Object)this.name);
                serverBuilder.addService((BindableService)service);
                continue;
            }
            if (!(service instanceof ServerServiceDefinition)) continue;
            ServerServiceDefinition definition = (ServerServiceDefinition)service;
            this.logger.info("Add ServerServiceDefinition={}, server={}", (Object)definition.getServiceDescriptor(), (Object)this.name);
            serverBuilder.addService(definition);
        }
        for (ServerTransportFilter transportFilter : this.serverTransportFilters) {
            this.logger.info("Add transportFilter={}, server={}", (Object)transportFilter, (Object)this.name);
            serverBuilder.addTransportFilter(transportFilter);
        }
        for (ServerInterceptor serverInterceptor : this.serverInterceptors) {
            this.logger.info("Add intercept={}, server={}", (Object)serverInterceptor, (Object)this.name);
            serverBuilder.intercept(serverInterceptor);
        }
        serverBuilder.executor(this.serverExecutor);
        if (this.callExecutor != null) {
            serverBuilder.callExecutor(this.callExecutor);
        }
        this.setupServerOption(serverBuilder);
        if (this.sslContext != null) {
            serverBuilder.sslContext(this.sslContext);
        }
        if ((server = serverBuilder.build()) instanceof InternalWithLogId) {
            InternalWithLogId logId = (InternalWithLogId)server;
            long serverLogId = logId.getLogId().getId();
            this.logger.info("{} serverLogId:{}", (Object)this.name, (Object)serverLogId);
            if (this.channelzRegistry != null) {
                this.channelzRegistry.register(serverLogId, this.name);
            }
        }
        return server;
    }

    public static ServerImplBuilder extractServerImplBuilder(NettyServerBuilder serverBuilder) throws NoSuchFieldException, IllegalAccessException {
        Field serverImplBuilderField = NettyServerBuilder.class.getDeclaredField("serverImplBuilder");
        serverImplBuilderField.setAccessible(true);
        return (ServerImplBuilder)serverImplBuilderField.get(serverBuilder);
    }

    private void setupInternal(ServerImplBuilder builder) {
        builder.setTracingEnabled(false);
        builder.setStatsEnabled(false);
        builder.setStatsRecordRealTimeMetrics(false);
        builder.setStatsRecordStartedRpcs(false);
    }

    private void setupServerOption(NettyServerBuilder builder) {
        builder.withChildOption(ChannelOption.TCP_NODELAY, (Object)true);
        builder.withChildOption(ChannelOption.SO_REUSEADDR, (Object)true);
        builder.withChildOption(ChannelOption.SO_RCVBUF, (Object)this.serverOption.getReceiveBufferSize());
        WriteBufferWaterMark disabledWriteBufferWaterMark = new WriteBufferWaterMark(0, Integer.MAX_VALUE);
        builder.withChildOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)disabledWriteBufferWaterMark);
        builder.handshakeTimeout(this.serverOption.getHandshakeTimeout(), TimeUnit.MILLISECONDS);
        builder.flowControlWindow(this.serverOption.getFlowControlWindow());
        builder.maxInboundMessageSize(this.serverOption.getMaxInboundMessageSize());
        builder.maxInboundMetadataSize(this.serverOption.getMaxHeaderListSize());
        builder.keepAliveTime(this.serverOption.getKeepAliveTime(), TimeUnit.MILLISECONDS);
        builder.keepAliveTimeout(this.serverOption.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
        builder.permitKeepAliveTime(this.serverOption.getPermitKeepAliveTime(), TimeUnit.MILLISECONDS);
        builder.permitKeepAliveWithoutCalls(this.serverOption.isPermitKeepAliveWithoutCalls());
        builder.maxConnectionIdle(this.serverOption.getMaxConnectionIdle(), TimeUnit.MILLISECONDS);
        builder.maxConnectionAge(this.serverOption.getMaxConnectionAge(), TimeUnit.MILLISECONDS);
        builder.maxConnectionAgeGrace(this.serverOption.getMaxConnectionAgeGrace(), TimeUnit.MILLISECONDS);
        builder.maxConcurrentCallsPerConnection(this.serverOption.getMaxConcurrentCallsPerConnection());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Set serverOption {}. name={}, hostname={}, port={}", (Object)this.serverOption, (Object)this.name, (Object)this.hostname, (Object)this.port);
        }
    }

    public void close() {
        Future workerShutdown = this.workerEventLoopGroup.shutdownGracefully();
        workerShutdown.awaitUninterruptibly();
        ExecutorUtils.shutdownExecutorService(this.name + "-Channel-Worker", this.workerExecutor);
        Future bossShutdown = this.bossEventLoopGroup.shutdownGracefully();
        bossShutdown.awaitUninterruptibly();
        ExecutorUtils.shutdownExecutorService(this.name + "-Channel-Boss", this.bossExecutor);
    }

    public String toString() {
        return "ServerFactory{name='" + this.name + '\'' + ", hostname='" + this.hostname + '\'' + ", port=" + this.port + '}';
    }
}

