/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mcp.sink.handler.impl;

import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpResponse;
import java.net.ConnectException;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.mcp.McpRetryConfig;
import org.apache.eventmesh.common.config.connector.mcp.SinkConnectorConfig;
import org.apache.eventmesh.connector.http.util.HttpUtils;
import org.apache.eventmesh.connector.mcp.sink.data.McpConnectRecord;
import org.apache.eventmesh.connector.mcp.sink.handler.AbstractMcpSinkHandler;
import org.apache.eventmesh.connector.mcp.sink.handler.McpSinkHandler;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpSinkHandlerRetryWrapper
extends AbstractMcpSinkHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(McpSinkHandlerRetryWrapper.class);
    private final McpRetryConfig mcpRetryConfig;
    private final McpSinkHandler sinkHandler;
    private final RetryPolicy<HttpResponse<Buffer>> retryPolicy;

    public McpSinkHandlerRetryWrapper(SinkConnectorConfig sinkConnectorConfig, McpSinkHandler sinkHandler) {
        super(sinkConnectorConfig);
        this.sinkHandler = sinkHandler;
        this.mcpRetryConfig = this.getSinkConnectorConfig().getRetryConfig();
        this.retryPolicy = this.buildRetryPolicy();
    }

    private RetryPolicy<HttpResponse<Buffer>> buildRetryPolicy() {
        return ((RetryPolicyBuilder)((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().handleIf(e -> e instanceof ConnectException)).handleResultIf(response -> this.mcpRetryConfig.isRetryOnNonSuccess() && !HttpUtils.is2xxSuccessful((int)response.statusCode()))).withMaxRetries(this.mcpRetryConfig.getMaxRetries()).withDelay(Duration.ofMillis(this.mcpRetryConfig.getInterval())).onRetry(event -> {
            if (log.isDebugEnabled()) {
                log.warn("Failed to deliver message after {} attempts. Retrying in {} ms. Error: {}", new Object[]{event.getAttemptCount(), this.mcpRetryConfig.getInterval(), event.getLastException()});
            } else {
                log.warn("Failed to deliver message after {} attempts. Retrying in {} ms.", (Object)event.getAttemptCount(), (Object)this.mcpRetryConfig.getInterval());
            }
        }).onFailure(event -> {
            if (log.isDebugEnabled()) {
                log.error("Failed to deliver message after {} attempts. Error: {}", (Object)event.getAttemptCount(), (Object)event.getException());
            } else {
                log.error("Failed to deliver message after {} attempts.", (Object)event.getAttemptCount());
            }
        })).build();
    }

    @Override
    public void start() {
        this.sinkHandler.start();
    }

    @Override
    public Future<HttpResponse<Buffer>> deliver(URI url, McpConnectRecord mcpConnectRecord, Map<String, Object> attributes, ConnectRecord connectRecord) {
        Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).getStageAsync(() -> this.sinkHandler.deliver(url, mcpConnectRecord, attributes, connectRecord).toCompletionStage());
        return null;
    }

    @Override
    public void stop() {
        this.sinkHandler.stop();
    }
}

