/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.resolver;

import com.google.common.base.Strings;
import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.resolver.URIResolver;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class DirectUriResolver
implements URIResolver {
    private static final List<String> SCHEMES = Arrays.asList("http", "https");
    private ConcurrentMap<URI, List<SocketAddress>> cache = new ConcurrentHashMap<URI, List<SocketAddress>>();

    DirectUriResolver() {
    }

    @Override
    public int priority() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean supports(URI uri) {
        if (!SCHEMES.contains(uri.getScheme())) {
            return false;
        }
        if (!Strings.isNullOrEmpty((String)uri.getPath())) {
            return false;
        }
        return uri.getPort() != -1;
    }

    @Override
    public List<SocketAddress> resolve(URI uri) {
        if (!this.supports(uri)) {
            throw EtcdExceptionFactory.newEtcdException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unsupported URI " + uri));
        }
        return this.cache.computeIfAbsent(uri, u -> Collections.singletonList(new InetSocketAddress(uri.getHost(), uri.getPort())));
    }
}

