/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.eventmesh.common.ResetCountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThreadWrapper
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadWrapper.class);
    private final AtomicBoolean started = new AtomicBoolean(false);
    protected Thread thread;
    protected final ResetCountDownLatch waiter = new ResetCountDownLatch(1);
    protected volatile AtomicBoolean hasWakeup = new AtomicBoolean(false);
    protected boolean isDaemon = false;
    protected volatile boolean isRunning = false;

    public abstract String getThreadName();

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            log.warn("Start thread:{} fail", (Object)this.getThreadName());
            return;
        }
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.setDaemon(this.isDaemon);
        this.thread.start();
        this.isRunning = true;
        log.info("Start thread:{} success", (Object)this.getThreadName());
    }

    public void await() {
        if (this.hasWakeup.compareAndSet(true, false)) {
            return;
        }
        this.waiter.reset();
        try {
            this.waiter.await();
        }
        catch (InterruptedException e) {
            log.error("Thread[{}] Interrupted", (Object)this.getThreadName(), (Object)e);
        }
        finally {
            this.hasWakeup.set(false);
        }
    }

    public void await(long timeout) {
        this.await(timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long timeout, TimeUnit timeUnit) {
        if (this.hasWakeup.compareAndSet(true, false)) {
            return;
        }
        this.waiter.reset();
        try {
            this.waiter.await(timeout, timeUnit == null ? TimeUnit.MILLISECONDS : timeUnit);
        }
        catch (InterruptedException e) {
            log.error("Thread[{}] Interrupted", (Object)this.getThreadName(), (Object)e);
        }
        finally {
            this.hasWakeup.set(false);
        }
    }

    public void wakeup() {
        if (this.hasWakeup.compareAndSet(false, true)) {
            this.waiter.countDown();
        }
    }

    public void shutdownImmediately() {
        this.shutdown(true);
    }

    public void shutdown() {
        this.shutdown(false);
    }

    private void shutdown(boolean interruptThread) {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        this.isRunning = false;
        this.wakeup();
        try {
            if (interruptThread) {
                this.thread.interrupt();
            }
            if (!this.isDaemon) {
                this.thread.join(TimeUnit.SECONDS.toMillis(60L));
            }
        }
        catch (InterruptedException e) {
            log.error("Thread[{}] Interrupted", (Object)this.getThreadName(), (Object)e);
        }
    }

    public void setDaemon(boolean daemon) {
        this.isDaemon = daemon;
    }

    public boolean isStated() {
        return this.started.get();
    }
}

