/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.common.profiler.logging.ThrottledLogger;
import com.navercorp.pinpoint.profiler.context.CallStackOverflowListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThrottledLogCallStackOverflowListener
implements CallStackOverflowListener {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final boolean isInfo = this.logger.isInfoEnabled();
    private final int maxDepth;
    private final int maxSequence;
    private ThrottledLogger throttledLogger;

    public ThrottledLogCallStackOverflowListener(int maxDepth, int maxSequence, int overflowLogRation) {
        this.maxDepth = maxDepth;
        this.maxSequence = maxSequence;
        this.throttledLogger = ThrottledLogger.getLogger((Logger)this.logger, (long)overflowLogRation);
    }

    @Override
    public void fireOverflow(int callStackIndex) {
        if (this.isInfo) {
            this.throttledLogger.info("CallStack maximum depth/sequence exceeded. Check the profiler.callstack.max.depth. current.index={}, max.depth={}, max.sequence={}", new Object[]{callStackIndex, this.maxDepth, this.maxSequence});
        }
    }
}

