/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.id;

import com.google.inject.Inject;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.profiler.context.id.LocalTraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TraceIdFactory;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TraceRootFactory;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import java.util.Objects;

public class DefaultTraceRootFactory
implements TraceRootFactory {
    private final String agentId;
    private final TraceIdFactory traceIdFactory;

    @Inject
    public DefaultTraceRootFactory(@AgentId String agentId, TraceIdFactory traceIdFactory) {
        this.agentId = Objects.requireNonNull(agentId, "agentId");
        this.traceIdFactory = Objects.requireNonNull(traceIdFactory, "traceIdFactory");
    }

    @Override
    public TraceRoot newTraceRoot(long transactionId) {
        TraceId traceId = this.traceIdFactory.newTraceId(transactionId);
        long startTime = this.traceStartTime();
        return TraceRoot.remote(traceId, this.agentId, startTime, transactionId);
    }

    @Override
    public LocalTraceRoot newDisableTraceRoot(long transactionId) {
        long startTime = this.traceStartTime();
        return TraceRoot.local(this.agentId, startTime, transactionId);
    }

    private long traceStartTime() {
        return System.currentTimeMillis();
    }

    @Override
    public TraceRoot continueTraceRoot(TraceId traceId, long transactionId) {
        Objects.requireNonNull(traceId, "traceId");
        long startTime = this.traceStartTime();
        return TraceRoot.remote(traceId, this.agentId, startTime, transactionId);
    }
}

