/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang.time.DateFormatUtils;

public class SqlTimestampConverter
implements Converter {
    public static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd", "HH:mm:ss", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd hh:mm:ss.fffffffff", "EEE MMM dd HH:mm:ss zzz yyyy", DateFormatUtils.ISO_DATETIME_FORMAT.getPattern(), DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), DateFormatUtils.SMTP_DATETIME_FORMAT.getPattern()};
    public static final Converter SQL_TIMESTAMP = new SqlTimestampConverter(null);
    private final Object defaultValue;
    private final boolean useDefault;

    public SqlTimestampConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public SqlTimestampConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value instanceof java.sql.Date && java.sql.Date.class.equals((Object)type)) {
            return value;
        }
        if (value instanceof Time && Time.class.equals((Object)type)) {
            return value;
        }
        if (value instanceof Timestamp && Timestamp.class.equals((Object)type)) {
            return value;
        }
        try {
            if (java.sql.Date.class.equals((Object)type)) {
                return new java.sql.Date(this.convertTimestamp2TimeMillis(value.toString()));
            }
            if (Time.class.equals((Object)type)) {
                return new Time(this.convertTimestamp2TimeMillis(value.toString()));
            }
            if (Timestamp.class.equals((Object)type)) {
                return new Timestamp(this.convertTimestamp2TimeMillis(value.toString()));
            }
            return new Timestamp(this.convertTimestamp2TimeMillis(value.toString()));
        }
        catch (Exception e) {
            throw new ConversionException("Value format invalid: " + e.getMessage(), (Throwable)e);
        }
    }

    private Long convertTimestamp2TimeMillis(String input) {
        if (input == null) {
            return null;
        }
        try {
            return Timestamp.valueOf(input).getTime();
        }
        catch (Exception nfe) {
            try {
                return this.parseDate(input, Locale.ENGLISH).getTime();
            }
            catch (Exception err) {
                try {
                    return this.parseDate(input, Locale.getDefault()).getTime();
                }
                catch (Exception err2) {
                    return Long.parseLong(input);
                }
            }
        }
    }

    private Date parseDate(String str, Locale locale) throws ParseException {
        if (str == null || DATE_FORMATS == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        for (int i = 0; i < DATE_FORMATS.length; ++i) {
            if (i == 0) {
                parser = new SimpleDateFormat(DATE_FORMATS[0], locale);
            } else {
                parser.applyPattern(DATE_FORMATS[i]);
            }
            pos.setIndex(0);
            Date date = parser.parse(str, pos);
            if (date == null || pos.getIndex() != str.length()) continue;
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }
}

