/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.sink.connector;

import com.alibaba.otter.canal.common.utils.NamedThreadFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.rdb.JdbcConfig;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalSinkConfig;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalSinkIncrementConfig;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.connector.canal.CanalConnectRecord;
import org.apache.eventmesh.connector.canal.DatabaseConnection;
import org.apache.eventmesh.connector.canal.SqlUtils;
import org.apache.eventmesh.connector.canal.dialect.DbDialect;
import org.apache.eventmesh.connector.canal.dialect.MysqlDialect;
import org.apache.eventmesh.connector.canal.interceptor.SqlBuilderLoadInterceptor;
import org.apache.eventmesh.connector.canal.model.EventColumn;
import org.apache.eventmesh.connector.canal.model.EventType;
import org.apache.eventmesh.connector.canal.sink.DbLoadContext;
import org.apache.eventmesh.connector.canal.sink.DbLoadData;
import org.apache.eventmesh.connector.canal.sink.DbLoadMerger;
import org.apache.eventmesh.connector.canal.sink.GtidBatch;
import org.apache.eventmesh.connector.canal.sink.GtidBatchManager;
import org.apache.eventmesh.connector.canal.source.table.RdbTableMgr;
import org.apache.eventmesh.openconnect.api.ConnectorCreateService;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.callback.SendExceptionContext;
import org.apache.eventmesh.openconnect.offsetmgmt.api.callback.SendResult;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.ConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.StatementCallback;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.util.CollectionUtils;

public class CanalSinkIncrementConnector
implements Sink,
ConnectorCreateService<Sink> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CanalSinkIncrementConnector.class);
    private CanalSinkIncrementConfig sinkConfig;
    private JdbcTemplate jdbcTemplate;
    private SqlBuilderLoadInterceptor interceptor;
    private DbDialect dbDialect;
    private ExecutorService executor;
    private ExecutorService gtidSingleExecutor;
    private int batchSize = 50;
    private boolean useBatch = true;
    private RdbTableMgr tableMgr;

    public Class<? extends Config> configClass() {
        return CanalSinkIncrementConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sinkConfig = (CanalSinkIncrementConfig)config;
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        CanalSinkConfig canalSinkConfig = (CanalSinkConfig)sinkConnectorContext.getSinkConfig();
        this.sinkConfig = (CanalSinkIncrementConfig)ConfigUtil.parse((Map)canalSinkConfig.getSinkConfig(), CanalSinkIncrementConfig.class);
        this.batchSize = this.sinkConfig.getBatchSize();
        this.useBatch = this.sinkConfig.getUseBatch();
        DatabaseConnection.sinkConfig = this.sinkConfig.getSinkConnectorConfig();
        DatabaseConnection.initSinkConnection();
        this.jdbcTemplate = new JdbcTemplate((DataSource)DatabaseConnection.sinkDataSource);
        this.dbDialect = new MysqlDialect(this.jdbcTemplate, (LobHandler)new DefaultLobHandler());
        this.interceptor = new SqlBuilderLoadInterceptor();
        this.interceptor.setDbDialect(this.dbDialect);
        this.tableMgr = new RdbTableMgr((JdbcConfig)this.sinkConfig.getSinkConnectorConfig(), (DataSource)DatabaseConnection.sinkDataSource);
        this.executor = new ThreadPoolExecutor(this.sinkConfig.getPoolSize(), this.sinkConfig.getPoolSize(), 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.sinkConfig.getPoolSize() * 4), (ThreadFactory)new NamedThreadFactory("canalSink"), new ThreadPoolExecutor.CallerRunsPolicy());
        this.gtidSingleExecutor = Executors.newSingleThreadExecutor(r -> new Thread(r, "gtidSingleExecutor"));
    }

    public void start() throws Exception {
        this.tableMgr.start();
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getSinkConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        this.executor.shutdown();
        this.gtidSingleExecutor.shutdown();
    }

    public void put(List<ConnectRecord> sinkRecords) {
        DbLoadContext context = new DbLoadContext();
        for (ConnectRecord connectRecord : sinkRecords) {
            List<CanalConnectRecord> canalConnectRecordList = new ArrayList<CanalConnectRecord>();
            List<CanalConnectRecord> canalConnectRecords = this.convertToCanalConnectRecord(connectRecord);
            for (CanalConnectRecord record : canalConnectRecords) {
                canalConnectRecordList.add((CanalConnectRecord)SerializationUtils.clone((Serializable)record));
            }
            if (this.isDdlDatas(canalConnectRecordList = this.filterRecord(canalConnectRecordList))) {
                this.doDdl(context, canalConnectRecordList, connectRecord);
                continue;
            }
            if (this.sinkConfig.isGTIDMode()) {
                this.doLoadWithGtid(context, this.sinkConfig, connectRecord);
                continue;
            }
            canalConnectRecordList = DbLoadMerger.merge(canalConnectRecordList);
            DbLoadData loadData = new DbLoadData();
            this.doBefore(canalConnectRecordList, loadData);
            this.doLoad(context, this.sinkConfig, loadData, connectRecord);
        }
    }

    public Sink create() {
        return new CanalSinkIncrementConnector();
    }

    private boolean isDdlDatas(List<CanalConnectRecord> canalConnectRecordList) {
        boolean result = false;
        for (CanalConnectRecord canalConnectRecord : canalConnectRecordList) {
            if (!(result |= canalConnectRecord.getEventType().isDdl()) || canalConnectRecord.getEventType().isDdl()) continue;
            throw new RuntimeException("ddl/dml can't be in one batch, it's may be a bug , pls submit issues.");
        }
        return result;
    }

    private List<CanalConnectRecord> filterRecord(List<CanalConnectRecord> canalConnectRecordList) {
        return canalConnectRecordList.stream().filter(record -> this.tableMgr.getTable(record.getSchemaName(), record.getTableName()) != null).collect(Collectors.toList());
    }

    private void doDdl(DbLoadContext context, List<CanalConnectRecord> canalConnectRecordList, ConnectRecord connectRecord) {
        for (final CanalConnectRecord record : canalConnectRecordList) {
            try {
                Boolean result = (Boolean)this.jdbcTemplate.execute((StatementCallback)new StatementCallback<Boolean>(){

                    public Boolean doInStatement(Statement stmt) throws SQLException, DataAccessException {
                        boolean result = true;
                        if (StringUtils.isNotEmpty((String)record.getDdlSchemaName())) {
                            result &= stmt.execute("use `" + record.getDdlSchemaName() + "`");
                        }
                        return result &= stmt.execute(record.getSql());
                    }
                });
                if (Boolean.TRUE.equals(result)) {
                    context.getProcessedRecords().add(record);
                    continue;
                }
                context.getFailedRecords().add(record);
            }
            catch (Throwable e) {
                connectRecord.getCallback().onException(this.buildSendExceptionContext(connectRecord, e));
                throw new RuntimeException(e);
            }
        }
        connectRecord.getCallback().onSuccess(this.convertToSendResult(connectRecord));
    }

    private SendExceptionContext buildSendExceptionContext(ConnectRecord record, Throwable e) {
        SendExceptionContext sendExceptionContext = new SendExceptionContext();
        sendExceptionContext.setMessageId(record.getRecordId());
        sendExceptionContext.setCause(e);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)record.getExtension("topic"))) {
            sendExceptionContext.setTopic(record.getExtension("topic"));
        }
        return sendExceptionContext;
    }

    private SendResult convertToSendResult(ConnectRecord record) {
        SendResult result = new SendResult();
        result.setMessageId(record.getRecordId());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)record.getExtension("topic"))) {
            result.setTopic(record.getExtension("topic"));
        }
        return result;
    }

    private void doBefore(List<CanalConnectRecord> canalConnectRecordList, DbLoadData loadData) {
        for (CanalConnectRecord record : canalConnectRecordList) {
            boolean filter = this.interceptor.before(this.sinkConfig, record);
            if (filter) continue;
            loadData.merge(record);
        }
    }

    private void doLoad(DbLoadContext context, CanalSinkIncrementConfig sinkConfig, DbLoadData loadData, ConnectRecord connectRecord) {
        ArrayList<List<CanalConnectRecord>> batchDatas = new ArrayList<List<CanalConnectRecord>>();
        for (DbLoadData.TableLoadData tableData : loadData.getTables()) {
            if (this.useBatch) {
                batchDatas.addAll(this.split(tableData.getDeleteDatas()));
                continue;
            }
            for (CanalConnectRecord data : tableData.getDeleteDatas()) {
                batchDatas.add(Arrays.asList(data));
            }
        }
        this.doTwoPhase(context, sinkConfig, batchDatas, true, connectRecord);
        batchDatas.clear();
        for (DbLoadData.TableLoadData tableData : loadData.getTables()) {
            if (this.useBatch) {
                batchDatas.addAll(this.split(tableData.getInsertDatas()));
                batchDatas.addAll(this.split(tableData.getUpdateDatas()));
                continue;
            }
            for (CanalConnectRecord data : tableData.getInsertDatas()) {
                batchDatas.add(Arrays.asList(data));
            }
            for (CanalConnectRecord data : tableData.getUpdateDatas()) {
                batchDatas.add(Arrays.asList(data));
            }
        }
        this.doTwoPhase(context, sinkConfig, batchDatas, true, connectRecord);
        batchDatas.clear();
    }

    private void doLoadWithGtid(DbLoadContext context, CanalSinkIncrementConfig sinkConfig, ConnectRecord connectRecord) {
        int batchIndex = (Integer)connectRecord.getExtension("batchIndex", Integer.class);
        int totalBatches = (Integer)connectRecord.getExtension("totalBatches", Integer.class);
        List<CanalConnectRecord> canalConnectRecordList = this.convertToCanalConnectRecord(connectRecord);
        String gtid = canalConnectRecordList.get(0).getCurrentGtid();
        GtidBatchManager.addBatch(gtid, batchIndex, totalBatches, canalConnectRecordList);
        if (GtidBatchManager.isComplete(gtid)) {
            GtidBatch batch = GtidBatchManager.getGtidBatch(gtid);
            List<List<CanalConnectRecord>> totalRows = batch.getBatches();
            ArrayList<CanalConnectRecord> filteredRows = new ArrayList<CanalConnectRecord>();
            for (List<CanalConnectRecord> canalConnectRecords : totalRows) {
                if (CollectionUtils.isEmpty(canalConnectRecords = this.filterRecord(canalConnectRecords))) continue;
                for (CanalConnectRecord record : canalConnectRecords) {
                    boolean filter = this.interceptor.before(sinkConfig, record);
                    filteredRows.add(record);
                }
            }
            context.setGtid(gtid);
            Future<Exception> result = this.gtidSingleExecutor.submit(new DbLoadWorker(context, filteredRows, this.dbDialect, false, sinkConfig));
            Exception ex = null;
            try {
                ex = result.get();
                if (ex == null) {
                    connectRecord.getCallback().onSuccess(this.convertToSendResult(connectRecord));
                }
            }
            catch (Exception e) {
                ex = e;
            }
            Boolean skipException = sinkConfig.getSkipException();
            if (skipException != null && skipException.booleanValue()) {
                if (ex != null) {
                    log.warn("skip exception will ack data : {} , caused by {}", filteredRows, (Object)ExceptionUtils.getFullStackTrace((Throwable)ex));
                    GtidBatchManager.removeGtidBatch(gtid);
                    connectRecord.getCallback().onSuccess(this.convertToSendResult(connectRecord));
                }
            } else if (ex != null) {
                log.error("sink connector will shutdown by " + ex.getMessage(), (Object)ExceptionUtils.getFullStackTrace((Throwable)ex));
                connectRecord.getCallback().onException(this.buildSendExceptionContext(connectRecord, ex));
                this.gtidSingleExecutor.shutdown();
                System.exit(1);
            } else {
                GtidBatchManager.removeGtidBatch(gtid);
            }
        } else {
            log.info("Batch received, waiting for other batches.");
            connectRecord.getCallback().onSuccess(this.convertToSendResult(connectRecord));
        }
    }

    private List<CanalConnectRecord> convertToCanalConnectRecord(ConnectRecord connectRecord) {
        List canalConnectRecordList;
        try {
            canalConnectRecordList = (List)JsonUtils.parseTypeReferenceObject((byte[])((byte[])connectRecord.getData()), (TypeReference)new TypeReference<List<CanalConnectRecord>>(){});
        }
        catch (Exception e) {
            log.error("Failed to parse the canalConnectRecords.", (Throwable)e);
            connectRecord.getCallback().onException(this.buildSendExceptionContext(connectRecord, e));
            throw new RuntimeException("Failed to parse the canalConnectRecords.", e);
        }
        return canalConnectRecordList;
    }

    private List<List<CanalConnectRecord>> split(List<CanalConnectRecord> records) {
        ArrayList<List<CanalConnectRecord>> result = new ArrayList<List<CanalConnectRecord>>();
        if (records == null || records.isEmpty()) {
            return result;
        }
        int[] bits = new int[records.size()];
        for (int i = 0; i < bits.length; ++i) {
            while (i < bits.length && bits[i] == 1) {
                ++i;
            }
            if (i >= bits.length) break;
            ArrayList<CanalConnectRecord> batch = new ArrayList<CanalConnectRecord>();
            bits[i] = 1;
            batch.add(records.get(i));
            for (int j = i + 1; j < bits.length && batch.size() < this.batchSize; ++j) {
                if (bits[j] != 0 || !this.canBatch(records.get(i), records.get(j))) continue;
                batch.add(records.get(j));
                bits[j] = 1;
            }
            result.add(batch);
        }
        return result;
    }

    private boolean canBatch(CanalConnectRecord source, CanalConnectRecord target) {
        return StringUtils.equals((String)source.getSchemaName(), (String)target.getSchemaName()) && StringUtils.equals((String)source.getTableName(), (String)target.getTableName()) && StringUtils.equals((String)source.getSql(), (String)target.getSql());
    }

    /*
     * WARNING - void declaration
     */
    private void doTwoPhase(DbLoadContext context, CanalSinkIncrementConfig sinkConfig, List<List<CanalConnectRecord>> totalRows, boolean canBatch, ConnectRecord connectRecord) {
        ArrayList<Future<Exception>> results = new ArrayList<Future<Exception>>();
        for (List<CanalConnectRecord> rows : totalRows) {
            if (CollectionUtils.isEmpty(rows)) continue;
            results.add(this.executor.submit(new DbLoadWorker(context, rows, this.dbDialect, canBatch, sinkConfig)));
        }
        boolean partFailed = false;
        for (Future future : results) {
            void var10_13;
            Object var10_14 = null;
            try {
                Exception exception = (Exception)future.get();
                if (exception == null) {
                    connectRecord.getCallback().onSuccess(this.convertToSendResult(connectRecord));
                }
            }
            catch (Exception e) {
                Exception exception = e;
            }
            if (var10_13 == null) continue;
            log.warn("##load phase one failed!", (Throwable)var10_13);
            partFailed = true;
        }
        if (partFailed) {
            ArrayList<CanalConnectRecord> retryRecords = new ArrayList<CanalConnectRecord>();
            for (List<CanalConnectRecord> list : totalRows) {
                retryRecords.addAll(list);
            }
            context.getFailedRecords().clear();
            Boolean bl = sinkConfig.getSkipException();
            if (bl != null && bl.booleanValue()) {
                for (CanalConnectRecord retryRecord : retryRecords) {
                    DbLoadWorker worker = new DbLoadWorker(context, Arrays.asList(retryRecord), this.dbDialect, false, sinkConfig);
                    try {
                        Exception ex = worker.call();
                        if (ex == null) continue;
                        log.warn("skip exception for data : {} , caused by {}", (Object)retryRecord, (Object)ExceptionUtils.getFullStackTrace((Throwable)ex));
                        connectRecord.getCallback().onSuccess(this.convertToSendResult(connectRecord));
                    }
                    catch (Exception ex) {
                        log.warn("skip exception for data : {} , caused by {}", (Object)retryRecord, (Object)ExceptionUtils.getFullStackTrace((Throwable)ex));
                        connectRecord.getCallback().onSuccess(this.convertToSendResult(connectRecord));
                    }
                }
            } else {
                DbLoadWorker dbLoadWorker = new DbLoadWorker(context, retryRecords, this.dbDialect, false, sinkConfig);
                try {
                    Exception ex = dbLoadWorker.call();
                    if (ex != null) {
                        throw ex;
                    }
                }
                catch (Exception ex) {
                    log.error("##load phase two failed!", (Throwable)ex);
                    log.error("sink connector will shutdown by " + ex.getMessage(), (Throwable)ex);
                    connectRecord.getCallback().onException(this.buildSendExceptionContext(connectRecord, ex));
                    this.executor.shutdown();
                    System.exit(1);
                }
            }
        }
    }

    class DbLoadWorker
    implements Callable<Exception> {
        private final DbLoadContext context;
        private final DbDialect dbDialect;
        private final List<CanalConnectRecord> records;
        private final boolean canBatch;
        private final CanalSinkIncrementConfig sinkConfig;
        private final List<CanalConnectRecord> allFailedRecords = new ArrayList<CanalConnectRecord>();
        private final List<CanalConnectRecord> allProcessedRecords = new ArrayList<CanalConnectRecord>();
        private final List<CanalConnectRecord> processedRecords = new ArrayList<CanalConnectRecord>();
        private final List<CanalConnectRecord> failedRecords = new ArrayList<CanalConnectRecord>();

        public DbLoadWorker(DbLoadContext context, List<CanalConnectRecord> records, DbDialect dbDialect, boolean canBatch, CanalSinkIncrementConfig sinkConfig) {
            this.context = context;
            this.records = records;
            this.canBatch = canBatch;
            this.dbDialect = dbDialect;
            this.sinkConfig = sinkConfig;
        }

        @Override
        public Exception call() throws Exception {
            try {
                return this.doCall();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Exception doCall() {
            RuntimeException error = null;
            ExecuteResult exeResult = null;
            if (this.sinkConfig.isGTIDMode()) {
                int retryCount = 0;
                ArrayList<CanalConnectRecord> toExecuteRecords = new ArrayList<CanalConnectRecord>();
                try {
                    if (!CollectionUtils.isEmpty(this.failedRecords)) {
                        toExecuteRecords.addAll(this.failedRecords);
                    } else {
                        toExecuteRecords.addAll(this.records);
                        this.failedRecords.addAll(toExecuteRecords);
                    }
                    JdbcTemplate template = this.dbDialect.getJdbcTemplate();
                    String sourceGtid = this.context.getGtid();
                    if (StringUtils.isNotEmpty((String)sourceGtid) && !this.sinkConfig.isMariaDB()) {
                        String setMySQLGtid = "SET @@session.gtid_next = '" + sourceGtid + "';";
                        template.execute(setMySQLGtid);
                        final LobCreator lobCreator = this.dbDialect.getLobHandler().getLobCreator();
                        int affect = (Integer)this.dbDialect.getTransactionTemplate().execute(status -> {
                            try {
                                this.failedRecords.clear();
                                this.processedRecords.clear();
                                int affect1 = 0;
                                for (final CanalConnectRecord record : toExecuteRecords) {
                                    int affects = template.update(record.getSql(), new PreparedStatementSetter(){

                                        public void setValues(PreparedStatement ps) throws SQLException {
                                            DbLoadWorker.this.doPreparedStatement(ps, DbLoadWorker.this.dbDialect, lobCreator, record);
                                        }
                                    });
                                    affect1 += affects;
                                    this.processStat(record, affects, false);
                                }
                                Integer n = affect1;
                                return n;
                            }
                            catch (Exception e) {
                                status.setRollbackOnly();
                                throw new RuntimeException("Failed to executed", e);
                            }
                            finally {
                                lobCreator.close();
                            }
                        });
                        if (this.sinkConfig.isMariaDB()) {
                            throw new RuntimeException("unsupport gtid mode for mariaDB");
                        }
                    } else {
                        if (StringUtils.isNotEmpty((String)sourceGtid) && this.sinkConfig.isMariaDB()) {
                            throw new RuntimeException("unsupport gtid mode for mariaDB");
                        }
                        log.error("gtid is empty in gtid mode");
                        throw new RuntimeException("gtid is empty in gtid mode");
                    }
                    String resetMySQLGtid = "SET @@session.gtid_next = 'AUTOMATIC';";
                    this.dbDialect.getJdbcTemplate().execute(resetMySQLGtid);
                    error = null;
                    exeResult = ExecuteResult.SUCCESS;
                }
                catch (DeadlockLoserDataAccessException ex) {
                    error = new RuntimeException(ExceptionUtils.getFullStackTrace((Throwable)ex));
                    exeResult = ExecuteResult.RETRY;
                }
                catch (Throwable ex) {
                    error = new RuntimeException(ExceptionUtils.getFullStackTrace((Throwable)ex));
                    exeResult = ExecuteResult.ERROR;
                }
                if (ExecuteResult.SUCCESS == exeResult) {
                    this.allFailedRecords.addAll(this.failedRecords);
                    this.allProcessedRecords.addAll(this.processedRecords);
                    this.failedRecords.clear();
                    this.processedRecords.clear();
                } else {
                    if (ExecuteResult.RETRY != exeResult) {
                        this.processedRecords.clear();
                        this.failedRecords.clear();
                        this.failedRecords.addAll(toExecuteRecords);
                        this.processFailedDatas(toExecuteRecords.size());
                        throw error;
                    }
                    ++retryCount;
                    this.processedRecords.clear();
                    this.failedRecords.clear();
                    this.failedRecords.addAll(toExecuteRecords);
                    int retry = 3;
                    if (retryCount >= retry) {
                        this.processFailedDatas(toExecuteRecords.size());
                        throw new RuntimeException(String.format("execute retry %s times failed", retryCount), error);
                    }
                    try {
                        int retryWait = 3000;
                        int wait = retryCount * retryWait;
                        wait = Math.max(wait, retryWait);
                        Thread.sleep(wait);
                    }
                    catch (InterruptedException ex) {
                        Thread.interrupted();
                        this.processFailedDatas(toExecuteRecords.size());
                        throw new RuntimeException(ex);
                    }
                }
            } else {
                int index = 0;
                block10: while (index < this.records.size()) {
                    final ArrayList<CanalConnectRecord> toExecuteRecords = new ArrayList<CanalConnectRecord>();
                    if (CanalSinkIncrementConnector.this.useBatch && this.canBatch) {
                        int end = Math.min(index + CanalSinkIncrementConnector.this.batchSize, this.records.size());
                        toExecuteRecords.addAll(this.records.subList(index, end));
                        index = end;
                    } else {
                        toExecuteRecords.add(this.records.get(index));
                        ++index;
                    }
                    int retryCount = 0;
                    while (true) {
                        try {
                            if (!CollectionUtils.isEmpty(this.failedRecords)) {
                                toExecuteRecords.clear();
                                toExecuteRecords.addAll(this.failedRecords);
                            } else {
                                this.failedRecords.addAll(toExecuteRecords);
                            }
                            final LobCreator lobCreator = this.dbDialect.getLobHandler().getLobCreator();
                            if (!CanalSinkIncrementConnector.this.useBatch || !this.canBatch) {
                                final CanalConnectRecord record = (CanalConnectRecord)toExecuteRecords.get(0);
                                JdbcTemplate template = this.dbDialect.getJdbcTemplate();
                                int affect = 0;
                                affect = (Integer)this.dbDialect.getTransactionTemplate().execute(status -> {
                                    try {
                                        this.failedRecords.clear();
                                        this.processedRecords.clear();
                                        int affect1 = template.update(record.getSql(), new PreparedStatementSetter(){

                                            public void setValues(PreparedStatement ps) throws SQLException {
                                                DbLoadWorker.this.doPreparedStatement(ps, DbLoadWorker.this.dbDialect, lobCreator, record);
                                            }
                                        });
                                        Integer n = affect1;
                                        return n;
                                    }
                                    catch (Exception e) {
                                        status.setRollbackOnly();
                                        throw new RuntimeException("Failed to executed", e);
                                    }
                                    finally {
                                        lobCreator.close();
                                    }
                                });
                                this.processStat(record, affect, false);
                            } else {
                                JdbcTemplate template = this.dbDialect.getJdbcTemplate();
                                String sql = ((CanalConnectRecord)toExecuteRecords.get(0)).getSql();
                                int[] affects = new int[toExecuteRecords.size()];
                                affects = (int[])this.dbDialect.getTransactionTemplate().execute(status -> {
                                    try {
                                        int[] affects1;
                                        this.failedRecords.clear();
                                        this.processedRecords.clear();
                                        int[] nArray = affects1 = template.batchUpdate(sql, new BatchPreparedStatementSetter(){

                                            public void setValues(PreparedStatement ps, int idx) throws SQLException {
                                                DbLoadWorker.this.doPreparedStatement(ps, DbLoadWorker.this.dbDialect, lobCreator, (CanalConnectRecord)toExecuteRecords.get(idx));
                                            }

                                            public int getBatchSize() {
                                                return toExecuteRecords.size();
                                            }
                                        });
                                        return nArray;
                                    }
                                    catch (Exception e) {
                                        status.setRollbackOnly();
                                        throw new RuntimeException("Failed to execute batch ", e);
                                    }
                                    finally {
                                        lobCreator.close();
                                    }
                                });
                                for (int i = 0; i < toExecuteRecords.size(); ++i) {
                                    assert (affects != null);
                                    this.processStat((CanalConnectRecord)toExecuteRecords.get(i), affects[i], true);
                                }
                            }
                            error = null;
                            exeResult = ExecuteResult.SUCCESS;
                        }
                        catch (DeadlockLoserDataAccessException ex) {
                            error = new RuntimeException(ExceptionUtils.getFullStackTrace((Throwable)ex));
                            exeResult = ExecuteResult.RETRY;
                        }
                        catch (Throwable ex) {
                            error = new RuntimeException(ExceptionUtils.getFullStackTrace((Throwable)ex));
                            exeResult = ExecuteResult.ERROR;
                        }
                        if (ExecuteResult.SUCCESS == exeResult) {
                            this.allFailedRecords.addAll(this.failedRecords);
                            this.allProcessedRecords.addAll(this.processedRecords);
                            this.failedRecords.clear();
                            this.processedRecords.clear();
                            continue block10;
                        }
                        if (ExecuteResult.RETRY != exeResult) {
                            this.processedRecords.clear();
                            this.failedRecords.clear();
                            this.failedRecords.addAll(toExecuteRecords);
                            this.processFailedDatas(index);
                            throw error;
                        }
                        ++retryCount;
                        this.processedRecords.clear();
                        this.failedRecords.clear();
                        this.failedRecords.addAll(toExecuteRecords);
                        int retry = 3;
                        if (retryCount >= retry) {
                            this.processFailedDatas(index);
                            throw new RuntimeException(String.format("execute retry %s times failed", retryCount), error);
                        }
                        try {
                            int retryWait = 3000;
                            int wait = retryCount * retryWait;
                            wait = Math.max(wait, retryWait);
                            Thread.sleep(wait);
                        }
                        catch (InterruptedException ex) {
                            Thread.interrupted();
                            this.processFailedDatas(index);
                            throw new RuntimeException(ex);
                        }
                    }
                }
            }
            this.context.getFailedRecords().addAll(this.allFailedRecords);
            this.context.getProcessedRecords().addAll(this.allProcessedRecords);
            return null;
        }

        private void doPreparedStatement(PreparedStatement ps, DbDialect dbDialect, LobCreator lobCreator, CanalConnectRecord record) throws SQLException {
            EventType type = record.getEventType();
            ArrayList<EventColumn> columns = new ArrayList<EventColumn>();
            if (type.isInsert()) {
                columns.addAll(record.getColumns());
                columns.addAll(record.getKeys());
            } else if (type.isDelete()) {
                columns.addAll(record.getKeys());
            } else if (type.isUpdate()) {
                boolean existOldKeys = !CollectionUtils.isEmpty(record.getOldKeys());
                columns.addAll(record.getUpdatedColumns());
                columns.addAll(record.getKeys());
                if (existOldKeys) {
                    columns.addAll(record.getOldKeys());
                }
            }
            for (int i = 0; i < columns.size(); ++i) {
                int paramIndex = i + 1;
                EventColumn column = (EventColumn)columns.get(i);
                int sqlType = column.getColumnType();
                Object param = null;
                param = dbDialect instanceof MysqlDialect && (sqlType == 92 || sqlType == 93 || sqlType == 91) ? column.getColumnValue() : SqlUtils.stringToSqlValue(column.getColumnValue(), sqlType, false, dbDialect.isEmptyStringNulled());
                try {
                    switch (sqlType) {
                        case 2005: {
                            lobCreator.setClobAsString(ps, paramIndex, (String)param);
                            break;
                        }
                        case 2004: {
                            lobCreator.setBlobAsBytes(ps, paramIndex, (byte[])param);
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            if (dbDialect instanceof MysqlDialect) {
                                ps.setObject(paramIndex, param);
                                break;
                            }
                            StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)paramIndex, (int)sqlType, null, (Object)param);
                            break;
                        }
                        case -7: {
                            if (dbDialect instanceof MysqlDialect) {
                                StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)paramIndex, (int)3, null, (Object)param);
                                break;
                            }
                            StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)paramIndex, (int)sqlType, null, (Object)param);
                            break;
                        }
                        default: {
                            StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)paramIndex, (int)sqlType, null, (Object)param);
                            break;
                        }
                    }
                    continue;
                }
                catch (SQLException ex) {
                    log.error("## SetParam error , [pairId={}, sqltype={}, value={}]", new Object[]{record.getPairId(), sqlType, param});
                    throw ex;
                }
            }
        }

        private void processStat(CanalConnectRecord record, int affect, boolean batch) {
            if (batch && affect < 1 && affect != -2) {
                this.failedRecords.add(record);
            } else if (!batch && affect < 1) {
                this.failedRecords.add(record);
            } else {
                this.processedRecords.add(record);
            }
        }

        private void processFailedDatas(int index) {
            this.allFailedRecords.addAll(this.failedRecords);
            this.context.getFailedRecords().addAll(this.allFailedRecords);
            while (index < this.records.size()) {
                this.context.getFailedRecords().add(this.records.get(index));
                ++index;
            }
            this.allProcessedRecords.addAll(this.processedRecords);
            this.context.getProcessedRecords().addAll(this.allProcessedRecords);
        }
    }

    static enum ExecuteResult {
        SUCCESS,
        ERROR,
        RETRY;

    }
}

