/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.pulsar.consumer;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventDeserializationException;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.api.exception.StorageRuntimeException;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.storage.pulsar.config.ClientConfiguration;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Config(field="clientConfiguration")
public class PulsarConsumerImpl
implements Consumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarConsumerImpl.class);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Properties properties;
    private PulsarClient pulsarClient;
    private EventListener eventListener;
    private final ConcurrentHashMap<String, org.apache.pulsar.client.api.Consumer<byte[]>> consumerMap = new ConcurrentHashMap();
    private ClientConfiguration clientConfiguration;

    public void init(Properties properties) throws Exception {
        this.properties = properties;
        String token = properties.getProperty("consumerToken");
        try {
            ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(this.clientConfiguration.getServiceAddr());
            if (this.clientConfiguration.getAuthPlugin() != null) {
                Preconditions.checkNotNull((Object)this.clientConfiguration.getAuthParams(), (Object)"Authentication Enabled in pulsar cluster, Please set authParams in pulsar-client.properties");
                clientBuilder.authentication(this.clientConfiguration.getAuthPlugin(), this.clientConfiguration.getAuthParams());
            }
            if (StringUtils.isNotBlank((CharSequence)token)) {
                clientBuilder.authentication(AuthenticationFactory.token((String)token));
            }
            this.pulsarClient = clientBuilder.build();
        }
        catch (Exception ex) {
            throw new StorageRuntimeException(String.format("Failed to connect pulsar with exception: %s", ex.getMessage()));
        }
    }

    public void start() {
        this.started.compareAndSet(false, true);
    }

    public void subscribe(String topic) throws Exception {
        final String subTopic = this.clientConfiguration.getTopicPrefix() + topic;
        if (this.pulsarClient == null) {
            throw new StorageRuntimeException(String.format("Cann't find the pulsar client for topic: %s", subTopic));
        }
        EventMeshAsyncConsumeContext consumeContext = new EventMeshAsyncConsumeContext(){

            public void commit(EventMeshAction action) {
                log.debug("message action: {} for topic: {}", (Object)action.name(), (Object)subTopic);
            }
        };
        SubscriptionType type = SubscriptionType.Shared;
        String consumerKey = topic + "/" + this.properties.getProperty("consumerGroup") + "/" + this.properties.getProperty("clientAddress");
        org.apache.pulsar.client.api.Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{subTopic}).subscriptionName(this.properties.getProperty("consumerGroup")).subscriptionMode(SubscriptionMode.Durable).subscriptionType(type).messageListener((MessageListener & Serializable)(ackConsumer, msg) -> {
            EventFormat eventFormat = Objects.requireNonNull(EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json"));
            CloudEvent cloudEvent = eventFormat.deserialize(msg.getData());
            this.eventListener.consume(cloudEvent, (AsyncConsumeContext)consumeContext);
            try {
                ackConsumer.acknowledge(msg);
            }
            catch (PulsarClientException ex) {
                throw new StorageRuntimeException(String.format("Failed to unsubscribe the topic:%s with exception: %s", subTopic, ex.getMessage()));
            }
            catch (EventDeserializationException ex) {
                log.warn("The Message isn't json format, with exception:{}", (Object)ex.getMessage());
            }
        }).subscribe();
        this.consumerMap.putIfAbsent(consumerKey, (org.apache.pulsar.client.api.Consumer<byte[]>)consumer);
    }

    public void unsubscribe(String topic) {
        try {
            String consumerKey = topic + "/" + this.properties.getProperty("consumerGroup") + "/" + this.properties.getProperty("clientAddress");
            org.apache.pulsar.client.api.Consumer<byte[]> consumer = this.consumerMap.get(consumerKey);
            consumer.unsubscribe();
            this.consumerMap.remove(consumerKey);
        }
        catch (PulsarClientException ex) {
            throw new StorageRuntimeException(String.format("Failed to unsubscribe the topic:%s with exception: %s", topic, ex.getMessage()));
        }
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
    }

    public void registerEventListener(EventListener listener) {
        this.eventListener = listener;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public void shutdown() {
        this.started.compareAndSet(true, false);
        try {
            this.consumerMap.forEach((key, consumer) -> {
                try {
                    consumer.close();
                }
                catch (PulsarClientException e) {
                    throw new StorageRuntimeException(String.format("Failed to close the pulsar consumer with exception: %s", e.getMessage()));
                }
            });
            this.pulsarClient.close();
            this.consumerMap.clear();
        }
        catch (PulsarClientException ex) {
            throw new StorageRuntimeException(String.format("Failed to close the pulsar client with exception: %s", ex.getMessage()));
        }
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }
}

