/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.file.sink.connector;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.file.FileSinkConfig;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSinkConnector
implements Sink {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileSinkConnector.class);
    private static final AtomicInteger fileSize = new AtomicInteger(0);
    private String filePath;
    private String fileName;
    private int flushSize;
    private boolean hourlyFlushEnabled;
    private FileSinkConfig sinkConfig;
    private PrintStream outputStream;

    public Class<? extends Config> configClass() {
        return FileSinkConfig.class;
    }

    public void init(Config config) {
        this.sinkConfig = (FileSinkConfig)config;
        this.filePath = this.buildFilePath();
        this.fileName = this.buildFileName();
        this.flushSize = this.sinkConfig.getFlushSize();
        this.hourlyFlushEnabled = this.sinkConfig.isHourlyFlushEnabled();
    }

    public void init(ConnectorContext connectorContext) {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (FileSinkConfig)sinkConnectorContext.getSinkConfig();
        this.fileName = this.buildFileName();
        this.filePath = this.buildFilePath();
        this.flushSize = this.sinkConfig.getFlushSize();
        this.hourlyFlushEnabled = this.sinkConfig.isHourlyFlushEnabled();
    }

    public void start() throws Exception {
        this.outputStream = this.fileName == null || this.fileName.length() == 0 || this.filePath == null || this.filePath.length() == 0 ? System.out : new PrintStream(Files.newOutputStream(Paths.get(this.filePath + this.fileName, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.APPEND), false, StandardCharsets.UTF_8.name());
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        this.outputStream.flush();
        this.outputStream.close();
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord connectRecord : sinkRecords) {
            if (fileSize.get() >= this.flushSize || this.hourlyFlushEnabled && LocalDateTime.now().getHour() == 0) {
                log.info("flush the file and open");
                this.outputStream.flush();
                this.outputStream.close();
                try {
                    fileSize.set(0);
                    this.outputStream = this.openWithNewFile();
                }
                catch (IOException e) {
                    log.error("create file under path {} error", (Object)this.filePath);
                    throw new RuntimeException(e);
                }
            }
            this.outputStream.println(new String((byte[])connectRecord.getData(), StandardCharsets.UTF_8));
            fileSize.addAndGet(1);
        }
    }

    private String buildFilePath() {
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        String filePath = this.sinkConfig.getConnectorConfig().getTopic() + File.separator + year + File.separator + month + File.separator + day + File.separator;
        File path = new File(filePath);
        if (!path.exists() && !path.mkdirs()) {
            log.error("make file dir {} error", (Object)filePath);
        }
        return filePath;
    }

    private String buildFileName() {
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        long currentTime = calendar.getTime().getTime();
        return this.sinkConfig.getConnectorConfig().getTopic() + "-" + calendar.get(11) + "-" + currentTime;
    }

    private PrintStream openWithNewFile() throws IOException {
        this.filePath = this.buildFilePath();
        this.fileName = this.buildFileName();
        if (this.fileName.length() == 0 || this.filePath == null || this.filePath.length() == 0) {
            return System.out;
        }
        return new PrintStream(Files.newOutputStream(Paths.get(this.filePath + this.fileName, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.APPEND), false, StandardCharsets.UTF_8.name());
    }
}

