/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.common;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.provider.EventFormatProvider;
import io.openmessaging.api.Message;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.Subscription;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.assertj.core.util.Preconditions;

public class MessageUtils {
    private static final int SEQ_LENGTH = 10;

    public static Package hello(UserAgent user) {
        Package msg = MessageUtils.getPackage(Command.HELLO_REQUEST);
        msg.setBody((Object)user);
        return msg;
    }

    public static Package heartBeat() {
        return MessageUtils.getPackage(Command.HEARTBEAT_REQUEST);
    }

    public static Package goodbye() {
        return MessageUtils.getPackage(Command.CLIENT_GOODBYE_REQUEST);
    }

    public static Package listen() {
        return MessageUtils.getPackage(Command.LISTEN_REQUEST);
    }

    public static Package subscribe(String topic, SubscriptionMode subscriptionMode, SubscriptionType subscriptionType) {
        Package msg = MessageUtils.getPackage(Command.SUBSCRIBE_REQUEST);
        msg.setBody((Object)MessageUtils.generateSubscription(topic, subscriptionMode, subscriptionType));
        return msg;
    }

    public static Package unsubscribe() {
        return MessageUtils.getPackage(Command.UNSUBSCRIBE_REQUEST);
    }

    public static Package asyncMessageAck(Package in) {
        return MessageUtils.getPackage(Command.ASYNC_MESSAGE_TO_CLIENT_ACK, in);
    }

    public static Package buildPackage(Object message, Command command) {
        Package msg = MessageUtils.getPackage(command);
        if (message instanceof CloudEvent) {
            CloudEvent cloudEvent = (CloudEvent)message;
            Preconditions.checkNotNull((Object)Objects.requireNonNull(cloudEvent.getDataContentType()), (String)"DateContentType cannot be null");
            msg.getHeader().putProperty("protocoltype", (Object)"cloudevents");
            msg.getHeader().putProperty("protocolversion", (Object)cloudEvent.getSpecVersion().toString());
            msg.getHeader().putProperty("protocoldesc", (Object)"tcp");
            byte[] bodyByte = Objects.requireNonNull(EventFormatProvider.getInstance().resolveFormat(cloudEvent.getDataContentType())).serialize((CloudEvent)message);
            msg.setBody((Object)bodyByte);
        } else if (message instanceof EventMeshMessage) {
            msg.getHeader().putProperty("protocoltype", (Object)"eventmeshmessage");
            msg.getHeader().putProperty("protocolversion", (Object)SpecVersion.V1.toString());
            msg.getHeader().putProperty("protocoldesc", (Object)"tcp");
            msg.setBody(message);
        } else if (message instanceof Message) {
            msg.getHeader().putProperty("protocoltype", (Object)"openmessage");
            msg.getHeader().putProperty("protocolversion", (Object)SpecVersion.V1.toString());
        } else {
            throw new IllegalArgumentException("Unsupported message protocol");
        }
        return msg;
    }

    public static Package broadcastMessageAck(Package in) {
        return MessageUtils.getPackage(Command.BROADCAST_MESSAGE_TO_CLIENT_ACK, in);
    }

    public static Package requestToClientAck(Package in) {
        return MessageUtils.getPackage(Command.REQUEST_TO_CLIENT_ACK, in);
    }

    public static Package responseToClientAck(Package in) {
        return MessageUtils.getPackage(Command.RESPONSE_TO_CLIENT_ACK, in);
    }

    public static UserAgent generateSubClient(UserAgent agent) {
        return MessageUtils.getUserAgent(agent, "sub");
    }

    public static UserAgent generatePubClient(UserAgent agent) {
        return MessageUtils.getUserAgent(agent, "pub");
    }

    private static Subscription generateSubscription(String topic, SubscriptionMode subscriptionMode, SubscriptionType subscriptionType) {
        Subscription subscription = new Subscription();
        ArrayList<SubscriptionItem> subscriptionItems = new ArrayList<SubscriptionItem>();
        subscriptionItems.add(new SubscriptionItem(topic, subscriptionMode, subscriptionType));
        subscription.setTopicList(subscriptionItems);
        return subscription;
    }

    private static String generateRandomString() {
        StringBuilder builder = new StringBuilder(10);
        IntStream.range(0, 10).forEach(i -> builder.append((char)ThreadLocalRandom.current().nextInt(48, 57)));
        return builder.toString();
    }

    private static Package getPackage(Command command) {
        Package msg = new Package();
        msg.setHeader(new Header(command, 0, null, MessageUtils.generateRandomString()));
        return msg;
    }

    private static Package getPackage(Command command, String seq, Object body) {
        Package msg = new Package();
        msg.setHeader(new Header(command, 0, null, seq));
        msg.setBody(body);
        return msg;
    }

    private static Package getPackage(Command command, Package in) {
        return MessageUtils.getPackage(command, in.getHeader().getSeq(), in.getBody());
    }

    private static UserAgent getUserAgent(UserAgent agent, String purpose) {
        return UserAgent.builder().env(agent.getEnv()).host(agent.getHost()).password(agent.getPassword()).username(agent.getUsername()).path(agent.getPath()).port(agent.getPort()).subsystem(agent.getSubsystem()).pid(agent.getPid()).version(agent.getVersion()).idc(agent.getIdc()).group(agent.getGroup()).purpose(purpose).build();
    }
}

