/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect.offsetmgmt.admin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.protobuf.Any;
import com.google.protobuf.UnsafeByteOperations;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.offset.OffsetStorageConfig;
import org.apache.eventmesh.common.protocol.grpc.adminserver.AdminServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.adminserver.Metadata;
import org.apache.eventmesh.common.protocol.grpc.adminserver.Payload;
import org.apache.eventmesh.common.remote.TaskState;
import org.apache.eventmesh.common.remote.datasource.DataSourceType;
import org.apache.eventmesh.common.remote.offset.RecordOffset;
import org.apache.eventmesh.common.remote.offset.RecordPartition;
import org.apache.eventmesh.common.remote.offset.RecordPosition;
import org.apache.eventmesh.common.remote.request.FetchPositionRequest;
import org.apache.eventmesh.common.remote.request.ReportPositionRequest;
import org.apache.eventmesh.common.remote.response.FetchPositionResponse;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.KeyValueStore;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.MemoryBasedKeyValueStore;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminOffsetService
implements OffsetManagementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminOffsetService.class);
    private String adminServerAddr;
    private ManagedChannel channel;
    private AdminServiceGrpc.AdminServiceStub adminServiceStub;
    private AdminServiceGrpc.AdminServiceBlockingStub adminServiceBlockingStub;
    StreamObserver<Payload> responseObserver;
    StreamObserver<Payload> requestObserver;
    public KeyValueStore<RecordPartition, RecordOffset> positionStore;
    private String jobId;
    private TaskState jobState;
    private DataSourceType dataSourceType;
    private DataSourceType dataSinkType;

    public void start() {
    }

    public void stop() {
    }

    public void configure(OffsetStorageConfig config) {
        super.configure(config);
    }

    public void persist() {
        Map recordMap = this.positionStore.getKVMap();
        ArrayList<RecordPosition> recordToSyncList = new ArrayList<RecordPosition>();
        for (Map.Entry entry : recordMap.entrySet()) {
            RecordPosition recordPosition = new RecordPosition((RecordPartition)entry.getKey(), (RecordOffset)entry.getValue());
            recordToSyncList.add(recordPosition);
        }
        ReportPositionRequest reportPositionRequest = new ReportPositionRequest();
        reportPositionRequest.setJobID(this.jobId);
        reportPositionRequest.setState(this.jobState);
        reportPositionRequest.setDataSourceType(this.dataSourceType);
        reportPositionRequest.setAddress(IPUtils.getLocalAddress());
        reportPositionRequest.setRecordPositionList(recordToSyncList);
        log.debug("start report position request: {}", (Object)JsonUtils.toJSONString((Object)reportPositionRequest));
        Metadata metadata = Metadata.newBuilder().setType(ReportPositionRequest.class.getSimpleName()).build();
        Payload payload = Payload.newBuilder().setMetadata(metadata).setBody(Any.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])Objects.requireNonNull(JsonUtils.toJSONBytes((Object)reportPositionRequest)))).build()).build();
        this.requestObserver.onNext((Object)payload);
        log.debug("end report position request: {}", (Object)JsonUtils.toJSONString((Object)reportPositionRequest));
        for (Map.Entry entry : recordMap.entrySet()) {
            this.positionStore.remove((Object)((RecordPartition)entry.getKey()));
        }
    }

    public void load() {
    }

    public void synchronize() {
    }

    public Map<RecordPartition, RecordOffset> getPositionMap() {
        if (this.positionStore.getKVMap() == null || this.positionStore.getKVMap().isEmpty()) {
            log.info("fetch position from admin server");
            FetchPositionRequest fetchPositionRequest = new FetchPositionRequest();
            fetchPositionRequest.setJobID(this.jobId);
            fetchPositionRequest.setAddress(IPUtils.getLocalAddress());
            fetchPositionRequest.setDataSourceType(this.dataSourceType);
            Metadata metadata = Metadata.newBuilder().setType(FetchPositionRequest.class.getSimpleName()).build();
            Payload request = Payload.newBuilder().setMetadata(metadata).setBody(Any.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])Objects.requireNonNull(JsonUtils.toJSONBytes((Object)fetchPositionRequest)))).build()).build();
            Payload response = this.adminServiceBlockingStub.invoke(request);
            if (response.getMetadata().getType().equals(FetchPositionResponse.class.getSimpleName())) {
                FetchPositionResponse fetchPositionResponse = (FetchPositionResponse)JsonUtils.parseObject((String)response.getBody().getValue().toStringUtf8(), FetchPositionResponse.class);
                assert (fetchPositionResponse != null);
                if (fetchPositionResponse.isSuccess()) {
                    for (RecordPosition recordPosition : fetchPositionResponse.getRecordPosition()) {
                        this.positionStore.put((Object)recordPosition.getRecordPartition(), (Object)recordPosition.getRecordOffset());
                    }
                }
            }
        }
        log.info("memory position map {}", (Object)this.positionStore.getKVMap());
        return this.positionStore.getKVMap();
    }

    public RecordOffset getPosition(RecordPartition partition) {
        if (this.positionStore.get((Object)partition) == null) {
            log.info("fetch position from admin server");
            FetchPositionRequest fetchPositionRequest = new FetchPositionRequest();
            fetchPositionRequest.setJobID(this.jobId);
            fetchPositionRequest.setAddress(IPUtils.getLocalAddress());
            fetchPositionRequest.setDataSourceType(this.dataSourceType);
            RecordPosition fetchRecordPosition = new RecordPosition();
            fetchRecordPosition.setRecordPartition(partition);
            fetchPositionRequest.setRecordPosition(fetchRecordPosition);
            Metadata metadata = Metadata.newBuilder().setType(FetchPositionRequest.class.getSimpleName()).build();
            Payload request = Payload.newBuilder().setMetadata(metadata).setBody(Any.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])Objects.requireNonNull(JsonUtils.toJSONBytes((Object)fetchPositionRequest)))).build()).build();
            Payload response = this.adminServiceBlockingStub.invoke(request);
            if (response.getMetadata().getType().equals(FetchPositionResponse.class.getSimpleName())) {
                FetchPositionResponse fetchPositionResponse = (FetchPositionResponse)JsonUtils.parseObject((String)response.getBody().getValue().toStringUtf8(), FetchPositionResponse.class);
                assert (fetchPositionResponse != null);
                if (fetchPositionResponse.isSuccess()) {
                    for (RecordPosition recordPosition : fetchPositionResponse.getRecordPosition()) {
                        this.positionStore.put((Object)recordPosition.getRecordPartition(), (Object)recordPosition.getRecordOffset());
                    }
                }
            }
        }
        log.info("memory record position {}", this.positionStore.get((Object)partition));
        return (RecordOffset)this.positionStore.get((Object)partition);
    }

    public void putPosition(Map<RecordPartition, RecordOffset> positions) {
        this.positionStore.putAll(positions);
    }

    public void putPosition(RecordPartition partition, RecordOffset position) {
        this.positionStore.put((Object)partition, (Object)position);
    }

    public void removePosition(List<RecordPartition> partitions) {
        if (partitions == null) {
            return;
        }
        for (RecordPartition partition : partitions) {
            this.positionStore.remove((Object)partition);
        }
    }

    public void initialize(OffsetStorageConfig offsetStorageConfig) {
        this.dataSourceType = offsetStorageConfig.getDataSourceType();
        this.dataSinkType = offsetStorageConfig.getDataSinkType();
        this.adminServerAddr = this.getRandomAdminServerAddr(offsetStorageConfig.getOffsetStorageAddr());
        this.channel = ManagedChannelBuilder.forTarget((String)this.adminServerAddr).usePlaintext().build();
        this.adminServiceStub = (AdminServiceGrpc.AdminServiceStub)AdminServiceGrpc.newStub((Channel)this.channel).withWaitForReady();
        this.adminServiceBlockingStub = (AdminServiceGrpc.AdminServiceBlockingStub)AdminServiceGrpc.newBlockingStub((Channel)this.channel).withWaitForReady();
        this.responseObserver = new StreamObserver<Payload>(){

            public void onNext(Payload response) {
                log.info("receive message: {} ", (Object)response);
            }

            public void onError(Throwable t) {
                log.error("receive error message: {}", (Object)t.getMessage());
            }

            public void onCompleted() {
                log.info("finished receive message and completed");
            }
        };
        this.requestObserver = this.adminServiceStub.invokeBiStream(this.responseObserver);
        this.positionStore = new MemoryBasedKeyValueStore();
        String offset = (String)offsetStorageConfig.getExtensions().get("offset");
        if (offset != null) {
            Map initialRecordOffsetMap = (Map)JsonUtils.parseTypeReferenceObject((String)offset, (TypeReference)new TypeReference<Map<RecordPartition, RecordOffset>>(){});
            log.info("init record offset {}", (Object)initialRecordOffsetMap);
            this.positionStore.putAll(initialRecordOffsetMap);
        }
        this.jobState = TaskState.RUNNING;
        this.jobId = (String)offsetStorageConfig.getExtensions().get("jobId");
    }

    private String getRandomAdminServerAddr(String adminServerAddrList) {
        String[] addresses = adminServerAddrList.split(";");
        if (addresses.length == 0) {
            throw new IllegalArgumentException("Admin server address list is empty");
        }
        Random random = new Random();
        int randomIndex = random.nextInt(addresses.length);
        return addresses[randomIndex];
    }
}

