/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.segment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.hash.HashHelper;
import io.pravega.shared.NameUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SegmentToContainerMapper {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentToContainerMapper.class);
    private final HashHelper hasher = HashHelper.seededWith((String)"SegmentToContainerMapper");
    private final int containerCount;
    private final boolean enableAdmin;

    public SegmentToContainerMapper(int containerCount, boolean enableAdmin) {
        Exceptions.checkArgument((containerCount > 0 ? 1 : 0) != 0, (String)"containerCount", (String)"containerCount must be a positive integer.", (Object[])new Object[0]);
        this.containerCount = containerCount;
        this.enableAdmin = enableAdmin;
    }

    public int getTotalContainerCount() {
        return this.containerCount;
    }

    public int getContainerId(String streamSegmentName) {
        if (!this.enableAdmin) {
            return this.getSegmentContainerId(streamSegmentName);
        }
        int containerId = Integer.MIN_VALUE;
        if (!this.isAddressableSegment(streamSegmentName)) {
            containerId = this.tryGetInternalMetadataSegmentContainerId(streamSegmentName);
        }
        return containerId >= 0 ? containerId : this.getSegmentContainerId(streamSegmentName);
    }

    private boolean isAddressableSegment(String streamSegmentName) {
        return !NameUtils.isMetadataSegmentName(streamSegmentName) && !NameUtils.isStorageMetadataSegmentName(streamSegmentName);
    }

    private int getSegmentContainerId(String streamSegmentName) {
        String primaryStreamSegmentName = NameUtils.extractPrimaryStreamSegmentName(streamSegmentName);
        if (primaryStreamSegmentName != null) {
            return this.mapStreamSegmentNameToContainerId(primaryStreamSegmentName);
        }
        return this.mapStreamSegmentNameToContainerId(streamSegmentName);
    }

    private int tryGetInternalMetadataSegmentContainerId(String streamSegmentName) {
        try {
            return Integer.parseInt(streamSegmentName.substring(streamSegmentName.lastIndexOf("_") + 1));
        }
        catch (NumberFormatException e) {
            log.warn("Metadata segment name has a not supported naming ({}), falling back to default assignment.", (Object)streamSegmentName);
            return Integer.MIN_VALUE;
        }
    }

    private int mapStreamSegmentNameToContainerId(String streamSegmentName) {
        return this.hasher.hashToBucket(streamSegmentName, this.containerCount);
    }
}

