/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.profiler.logging;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;

public class ThrottledLogger {
    private final Logger logger;
    private final long ratio;
    private final AtomicLong counter = new AtomicLong();

    public static ThrottledLogger getLogger(Logger logger, long ratio) {
        Objects.requireNonNull(logger, "logger");
        return new ThrottledLogger(logger, ratio);
    }

    private ThrottledLogger(Logger logger, long ratio) {
        this.logger = Objects.requireNonNull(logger, "logger");
        this.ratio = Math.max(ratio, 1L);
    }

    private boolean checkLogCounter() {
        return this.counter.getAndIncrement() % this.ratio == 0L;
    }

    public long getCounter() {
        return this.counter.get();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String msg) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.info(msg);
    }

    public void info(String msg, Object arg) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.info(msg, arg);
    }

    public void info(String msg, Object arg1, Object arg2) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.info(msg, arg1, arg2);
    }

    public void info(String msg, Throwable t) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.info(msg, t);
    }

    public void info(String msg, Object ... args) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.info(msg, args);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.debug(msg);
    }

    public void debug(String msg, Object arg) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.debug(msg, arg);
    }

    public void debug(String msg, Object arg1, Object arg2) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.debug(msg, arg1, arg2);
    }

    public void debug(String msg, Throwable t) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.debug(msg, t);
    }

    public void debug(String msg, Object ... args) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.debug(msg, args);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String msg) {
        if (!this.logger.isWarnEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.warn(msg);
    }

    public void warn(String msg, Object arg) {
        if (!this.logger.isWarnEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.warn(msg, arg);
    }

    public void warn(String msg, Object arg1, Object arg2) {
        if (!this.logger.isWarnEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.warn(msg, arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        if (!this.logger.isWarnEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.warn(msg, t);
    }

    public void warn(String msg, Object ... args) {
        if (!this.logger.isWarnEnabled()) {
            return;
        }
        if (!this.checkLogCounter()) {
            return;
        }
        this.logger.warn(msg, args);
    }
}

