/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.remote.datasource;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.eventmesh.common.remote.datasource.DataSourceClassify;
import org.apache.eventmesh.common.remote.datasource.DataSourceDriverType;

public enum DataSourceType {
    MYSQL("MySQL", DataSourceDriverType.MYSQL, DataSourceClassify.RDB),
    MariaDB("MariaDB", DataSourceDriverType.MariaDB, DataSourceClassify.RDB),
    REDIS("Redis", DataSourceDriverType.REDIS, DataSourceClassify.CACHE),
    ROCKETMQ("RocketMQ", DataSourceDriverType.ROCKETMQ, DataSourceClassify.MQ),
    HTTP("HTTP", DataSourceDriverType.HTTP, DataSourceClassify.TUNNEL);

    private static final Map<String, DataSourceType> INDEX_TYPES;
    private static final DataSourceType[] TYPES;
    private final String name;
    private final DataSourceDriverType driverType;
    private final DataSourceClassify classify;

    private DataSourceType(String name, DataSourceDriverType driverType, DataSourceClassify classify) {
        this.name = name;
        this.driverType = driverType;
        this.classify = classify;
    }

    public static DataSourceType getDataSourceType(String index) {
        if (index == null || index.isEmpty()) {
            return null;
        }
        return INDEX_TYPES.get(index);
    }

    public static DataSourceType getDataSourceType(Integer index) {
        if (index == null || index < 0 || index >= TYPES.length) {
            return null;
        }
        return TYPES[index];
    }

    public static DataSourceType fromString(String type) {
        for (DataSourceType dataSourceType : DataSourceType.values()) {
            if (!dataSourceType.name().equalsIgnoreCase(type)) continue;
            return dataSourceType;
        }
        throw new IllegalArgumentException("No enum constant for type: " + type);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public DataSourceDriverType getDriverType() {
        return this.driverType;
    }

    @Generated
    public DataSourceClassify getClassify() {
        return this.classify;
    }

    @Generated
    public String toString() {
        return "DataSourceType." + this.name() + "(name=" + this.getName() + ", driverType=" + (Object)((Object)this.getDriverType()) + ", classify=" + (Object)((Object)this.getClassify()) + ")";
    }

    static {
        INDEX_TYPES = new HashMap<String, DataSourceType>();
        for (DataSourceType type : TYPES = DataSourceType.values()) {
            INDEX_TYPES.put(type.name(), type);
        }
    }
}

