/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolMetrics {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProtocolMetrics.class);
    private static final ProtocolMetrics INSTANCE = new ProtocolMetrics();
    private final Map<String, ProtocolStats> protocolStats = new ConcurrentHashMap<String, ProtocolStats>();

    private ProtocolMetrics() {
    }

    public static ProtocolMetrics getInstance() {
        return INSTANCE;
    }

    public void recordSuccess(String protocolType, String operationType, long duration) {
        this.getOrCreateStats(protocolType).recordSuccess(operationType, duration);
    }

    public void recordFailure(String protocolType, String operationType, String error) {
        this.getOrCreateStats(protocolType).recordFailure(operationType, error);
    }

    public ProtocolStats getStats(String protocolType) {
        return this.protocolStats.get(protocolType);
    }

    public Map<String, ProtocolStats> getAllStats() {
        return new ConcurrentHashMap<String, ProtocolStats>(this.protocolStats);
    }

    public void resetStats(String protocolType) {
        ProtocolStats stats = this.protocolStats.get(protocolType);
        if (stats != null) {
            stats.reset();
        }
    }

    public void resetAllStats() {
        this.protocolStats.values().forEach(ProtocolStats::reset);
    }

    private ProtocolStats getOrCreateStats(String protocolType) {
        return this.protocolStats.computeIfAbsent(protocolType, k -> new ProtocolStats());
    }

    public static class OperationStats {
        private final AtomicLong successCount = new AtomicLong(0L);
        private final AtomicLong failureCount = new AtomicLong(0L);
        private final AtomicLong totalDuration = new AtomicLong(0L);
        private volatile long minDuration = Long.MAX_VALUE;
        private volatile long maxDuration = 0L;
        private volatile String lastError;

        void recordSuccess(long duration) {
            this.successCount.incrementAndGet();
            this.totalDuration.addAndGet(duration);
            if (duration < this.minDuration) {
                this.minDuration = duration;
            }
            if (duration > this.maxDuration) {
                this.maxDuration = duration;
            }
        }

        void recordFailure(String error) {
            this.failureCount.incrementAndGet();
            this.lastError = error;
        }

        public long getSuccessCount() {
            return this.successCount.get();
        }

        public long getFailureCount() {
            return this.failureCount.get();
        }

        public long getTotalCount() {
            return this.successCount.get() + this.failureCount.get();
        }

        public double getAverageDuration() {
            long count = this.successCount.get();
            if (count == 0L) {
                return 0.0;
            }
            return (double)this.totalDuration.get() / (double)count;
        }

        public long getMinDuration() {
            return this.minDuration == Long.MAX_VALUE ? 0L : this.minDuration;
        }

        public long getMaxDuration() {
            return this.maxDuration;
        }

        public double getSuccessRate() {
            long total = this.getTotalCount();
            if (total == 0L) {
                return 0.0;
            }
            return (double)this.successCount.get() / (double)total * 100.0;
        }

        public String getLastError() {
            return this.lastError;
        }

        public String toString() {
            return String.format("OperationStats{success=%d, failure=%d, avgDuration=%.2fms, successRate=%.2f%%}", this.getSuccessCount(), this.getFailureCount(), this.getAverageDuration(), this.getSuccessRate());
        }
    }

    public static class ProtocolStats {
        private final Map<String, OperationStats> operationStats = new ConcurrentHashMap<String, OperationStats>();
        private final AtomicLong totalOperations = new AtomicLong(0L);
        private final AtomicLong totalErrors = new AtomicLong(0L);
        private volatile long lastOperationTime = System.currentTimeMillis();

        void recordSuccess(String operationType, long duration) {
            this.getOrCreateOperationStats(operationType).recordSuccess(duration);
            this.totalOperations.incrementAndGet();
            this.lastOperationTime = System.currentTimeMillis();
        }

        void recordFailure(String operationType, String error) {
            this.getOrCreateOperationStats(operationType).recordFailure(error);
            this.totalOperations.incrementAndGet();
            this.totalErrors.incrementAndGet();
            this.lastOperationTime = System.currentTimeMillis();
        }

        public OperationStats getOperationStats(String operationType) {
            return this.operationStats.get(operationType);
        }

        public Map<String, OperationStats> getAllOperationStats() {
            return new ConcurrentHashMap<String, OperationStats>(this.operationStats);
        }

        public long getTotalOperations() {
            return this.totalOperations.get();
        }

        public long getTotalErrors() {
            return this.totalErrors.get();
        }

        public double getSuccessRate() {
            long total = this.totalOperations.get();
            if (total == 0L) {
                return 0.0;
            }
            return (double)(total - this.totalErrors.get()) / (double)total * 100.0;
        }

        public long getLastOperationTime() {
            return this.lastOperationTime;
        }

        void reset() {
            this.operationStats.clear();
            this.totalOperations.set(0L);
            this.totalErrors.set(0L);
            this.lastOperationTime = System.currentTimeMillis();
        }

        private OperationStats getOrCreateOperationStats(String operationType) {
            return this.operationStats.computeIfAbsent(operationType, k -> new OperationStats());
        }

        public String toString() {
            return String.format("ProtocolStats{operations=%d, errors=%d, successRate=%.2f%%, lastOp=%d}", this.getTotalOperations(), this.getTotalErrors(), this.getSuccessRate(), this.getLastOperationTime());
        }
    }
}

