/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.client.UnSubscribeRequestBody;
import org.apache.eventmesh.common.protocol.http.body.client.UnSubscribeResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.client.UnSubscribeRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.client.UnSubscribeResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.consumer.SubscriptionManager;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.AbstractHttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.metrics.http.HttpMetrics;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnSubscribeProcessor
extends AbstractHttpRequestProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnSubscribeProcessor.class);
    private final transient EventMeshHTTPServer eventMeshHTTPServer;

    public UnSubscribeProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(ChannelHandlerContext ctx, AsyncContext<HttpCommand> asyncContext) throws Exception {
        HttpCommand request = asyncContext.getRequest();
        String localAddress = IPUtils.getLocalAddress();
        log.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(request.getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), localAddress});
        UnSubscribeRequestHeader unSubscribeRequestHeader = (UnSubscribeRequestHeader)request.getHeader();
        UnSubscribeRequestBody unSubscribeRequestBody = (UnSubscribeRequestBody)request.getBody();
        EventMeshHTTPConfiguration eventMeshHttpConfiguration = this.eventMeshHTTPServer.getEventMeshHttpConfiguration();
        UnSubscribeResponseHeader unSubscribeResponseHeader = UnSubscribeResponseHeader.buildHeader((Integer)Integer.valueOf(request.getRequestCode()), (String)eventMeshHttpConfiguration.getEventMeshCluster(), (String)localAddress, (String)eventMeshHttpConfiguration.getEventMeshEnv(), (String)eventMeshHttpConfiguration.getEventMeshIDC());
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{unSubscribeRequestHeader.getIdc(), unSubscribeRequestHeader.getPid(), unSubscribeRequestHeader.getSys()}) || !StringUtils.isNumeric((CharSequence)unSubscribeRequestHeader.getPid())) {
            this.completeResponse(request, asyncContext, unSubscribeResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, null, UnSubscribeResponseBody.class);
            return;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{unSubscribeRequestBody.getUrl(), unSubscribeRequestBody.getConsumerGroup()}) || CollectionUtils.isEmpty((Collection)unSubscribeRequestBody.getTopics())) {
            this.completeResponse(request, asyncContext, unSubscribeResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, null, UnSubscribeResponseBody.class);
            return;
        }
        String pid = unSubscribeRequestHeader.getPid();
        String consumerGroup = unSubscribeRequestBody.getConsumerGroup();
        String unSubscribeUrl = unSubscribeRequestBody.getUrl();
        List unSubTopicList = unSubscribeRequestBody.getTopics();
        HttpMetrics summaryMetrics = this.eventMeshHTTPServer.getEventMeshHttpMetricsManager().getHttpMetrics();
        CompleteHandler<HttpCommand> handler = httpCommand -> {
            try {
                log.debug("{}", httpCommand);
                this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                summaryMetrics.recordHTTPReqResTimeCost(System.currentTimeMillis() - request.getReqTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        SubscriptionManager subscriptionManager = this.eventMeshHTTPServer.getSubscriptionManager();
        ConcurrentHashMap<String, ConsumerGroupConf> localConsumerGroupMap = subscriptionManager.getLocalConsumerGroupMapping();
        ConcurrentHashMap<String, List<Client>> concurrentHashMap = subscriptionManager.getLocalClientInfoMapping();
        synchronized (concurrentHashMap) {
            boolean isChange = true;
            this.registerClient(unSubscribeRequestHeader, consumerGroup, unSubTopicList, unSubscribeUrl);
            for (String unSubTopic : unSubTopicList) {
                List<Client> groupTopicClients = subscriptionManager.getLocalClientInfoMapping().get(consumerGroup + "@" + unSubTopic);
                Iterator<Client> clientIterator = groupTopicClients.iterator();
                while (clientIterator.hasNext()) {
                    Client client = clientIterator.next();
                    if (!StringUtils.equals((CharSequence)client.getPid(), (CharSequence)pid) || !StringUtils.equals((CharSequence)client.getUrl(), (CharSequence)unSubscribeUrl)) continue;
                    log.warn("client {} start unsubscribe", (Object)JsonUtils.toJSONString((Object)client));
                    clientIterator.remove();
                }
                if (CollectionUtils.isNotEmpty(groupTopicClients)) {
                    HashMap<String, List<String>> idcUrls = new HashMap<String, List<String>>();
                    HashSet<String> clientUrls = new HashSet<String>();
                    for (Client client : groupTopicClients) {
                        if (StringUtils.equals((CharSequence)unSubscribeUrl, (CharSequence)client.getUrl())) continue;
                        clientUrls.add(client.getUrl());
                        idcUrls.computeIfAbsent(client.getIdc(), k -> new ArrayList());
                    }
                    ConcurrentHashMap<String, ConsumerGroupConf> concurrentHashMap2 = localConsumerGroupMap;
                    synchronized (concurrentHashMap2) {
                        ConsumerGroupConf consumerGroupConf = localConsumerGroupMap.get(consumerGroup);
                        Map<String, ConsumerGroupTopicConf> map = consumerGroupConf.getConsumerGroupTopicConf();
                        for (Map.Entry<String, ConsumerGroupTopicConf> topicConf : map.entrySet()) {
                            if (!StringUtils.equals((CharSequence)unSubTopic, (CharSequence)topicConf.getKey())) continue;
                            ConsumerGroupTopicConf latestTopicConf = new ConsumerGroupTopicConf();
                            latestTopicConf.setConsumerGroup(consumerGroup);
                            latestTopicConf.setTopic(unSubTopic);
                            latestTopicConf.setSubscriptionItem(topicConf.getValue().getSubscriptionItem());
                            latestTopicConf.setUrls(clientUrls);
                            latestTopicConf.setIdcUrls(idcUrls);
                            map.put(unSubTopic, latestTopicConf);
                        }
                        localConsumerGroupMap.put(consumerGroup, consumerGroupConf);
                        continue;
                    }
                }
                isChange = false;
                break;
            }
            long startTime = System.currentTimeMillis();
            if (isChange) {
                try {
                    this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, localConsumerGroupMap.get(consumerGroup));
                    HttpCommand responseEventMeshCommand = request.createHttpCommandResponse(EventMeshRetCode.SUCCESS);
                    asyncContext.onComplete(responseEventMeshCommand, handler);
                }
                catch (Exception e) {
                    this.completeResponse(request, asyncContext, unSubscribeResponseHeader, EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR, EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2), UnSubscribeResponseBody.class);
                    long endTime = System.currentTimeMillis();
                    log.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|url={}", new Object[]{endTime - startTime, JsonUtils.toJSONString((Object)unSubscribeRequestBody.getTopics()), unSubscribeRequestBody.getUrl(), e});
                    summaryMetrics.recordSendMsgFailed();
                    summaryMetrics.recordSendMsgCost(endTime - startTime);
                }
            } else {
                try {
                    this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, null);
                    HttpCommand responseEventMeshCommand = request.createHttpCommandResponse(EventMeshRetCode.SUCCESS);
                    asyncContext.onComplete(responseEventMeshCommand, handler);
                    subscriptionManager.getLocalClientInfoMapping().keySet().removeIf(s -> StringUtils.contains((CharSequence)s, (CharSequence)consumerGroup));
                    localConsumerGroupMap.keySet().removeIf(s -> StringUtils.equals((CharSequence)consumerGroup, (CharSequence)s));
                }
                catch (Exception e) {
                    this.completeResponse(request, asyncContext, unSubscribeResponseHeader, EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR, EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2), UnSubscribeResponseBody.class);
                    long endTime = System.currentTimeMillis();
                    log.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|url={}", new Object[]{endTime - startTime, JsonUtils.toJSONString((Object)unSubscribeRequestBody.getTopics()), unSubscribeRequestBody.getUrl(), e});
                    summaryMetrics.recordSendMsgFailed();
                    summaryMetrics.recordSendMsgCost(endTime - startTime);
                }
            }
            this.eventMeshHTTPServer.getSubscriptionManager().updateMetaData();
        }
    }

    @Override
    public Executor executor() {
        return this.eventMeshHTTPServer.getHttpThreadPoolGroup().getClientManageExecutor();
    }

    private void registerClient(UnSubscribeRequestHeader unSubscribeRequestHeader, String consumerGroup, List<String> topicList, String url) {
        for (String topic : topicList) {
            Client client = new Client();
            client.setEnv(unSubscribeRequestHeader.getEnv());
            client.setIdc(unSubscribeRequestHeader.getIdc());
            client.setSys(unSubscribeRequestHeader.getSys());
            client.setIp(unSubscribeRequestHeader.getIp());
            client.setPid(unSubscribeRequestHeader.getPid());
            client.setConsumerGroup(consumerGroup);
            client.setTopic(topic);
            client.setUrl(url);
            client.setLastUpTime(new Date());
            String groupTopicKey = client.getConsumerGroup() + "@" + client.getTopic();
            ConcurrentHashMap<String, List<Client>> localClientInfoMap = this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping();
            if (localClientInfoMap.containsKey(groupTopicKey)) {
                List<Client> localClients = localClientInfoMap.get(groupTopicKey);
                boolean isContains = false;
                for (Client localClient : localClients) {
                    if (!StringUtils.equals((CharSequence)localClient.getUrl(), (CharSequence)client.getUrl())) continue;
                    isContains = true;
                    localClient.setLastUpTime(client.getLastUpTime());
                    break;
                }
                if (isContains) continue;
                localClients.add(client);
                continue;
            }
            ArrayList<Client> clients = new ArrayList<Client>();
            clients.add(client);
            localClientInfoMap.put(groupTopicKey, clients);
        }
    }
}

